import React from "react";
import { FlexboxProps, LayoutProps, MaxWidthProps, PaddingProps } from "styled-system";
import { IconType } from "../../icon";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
export declare type VariantType = "default" | "alternate";
interface MenuItemBaseProps extends TagProps, LayoutProps, FlexboxProps, PaddingProps {
    /** Custom className */
    className?: string;
    /** onClick handler */
    onClick?: (event: React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** Defines which direction the submenu will hang eg. left/right */
    submenuDirection?: string;
    /** Is the menu item the currently selected item. */
    selected?: boolean;
    /** A title for the menu item that has a submenu. */
    submenu?: string | boolean;
    /** The href to use for the menu item. */
    href?: string;
    /** onKeyDown handler */
    onKeyDown?: (event: React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** The target to use for the menu item. */
    target?: string;
    /** The rel attribute to be used for the underlying <a> tag */
    rel?: string;
    /** set the colour variant for a menuType */
    variant?: VariantType;
    /** Flag to display the dropdown arrow when an item has a submenu */
    showDropdownArrow?: boolean;
    /** If no text is provided an ariaLabel should be given to facilitate accessibility. */
    ariaLabel?: string;
    /** Callback triggered when submenu opens. Only valid with submenu prop */
    onSubmenuOpen?: () => void;
    /** Callback triggered when submenu closes. Only valid with submenu prop */
    onSubmenuClose?: () => void;
    /**
      @ignore @private
      private prop, used inside ScrollableBlock to ensure the MenuItem's color variant overrides the CSS
      for other MenuItems inside the block
     */
    overrideColor?: boolean;
    /** @private @ignore */
    "data-component"?: string;
    /** When set the submenu opens by click instead of hover */
    clickToOpen?: boolean;
    /** Sets the maxWidth of the MenuItem */
    maxWidth?: MaxWidthProps["maxWidth"];
    /**
     * @private @ignore
     * Renders MenuItem as a div element
     * */
    as?: "div";
}
export interface MenuWithChildren extends MenuItemBaseProps {
    children?: React.ReactNode;
    /** Either prop `icon` must be defined or this node must have children. */
    icon?: IconType;
}
export interface MenuWithIcon extends MenuItemBaseProps {
    /** Either prop `icon` must be defined or this node must have children. */
    icon: IconType;
    children?: React.ReactNode;
}
export declare const MenuItem: {
    ({ submenu, children, href, onClick, target, submenuDirection, icon, selected, onKeyDown, variant, showDropdownArrow, ariaLabel, clickToOpen, maxWidth, onSubmenuOpen, onSubmenuClose, overrideColor, rel, as, ...rest }: MenuWithChildren | MenuWithIcon): React.JSX.Element;
    displayName: string;
};
export default MenuItem;
