"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledMenuModal = exports.StyledMenuFullscreenHeader = exports.StyledMenuFullscreen = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _themes = require("../../../style/themes");
var _iconButton = _interopRequireDefault(require("../../icon-button/icon-button.style"));
var _box = _interopRequireDefault(require("../../box/box.style"));
var _search = _interopRequireDefault(require("../../search/search.style"));
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
var _button = _interopRequireDefault(require("../../button/button.style"));
var _menu = _interopRequireDefault(require("../menu.config"));
var _addFocusStyling = _interopRequireDefault(require("../../../style/utils/add-focus-styling"));
var _link = require("../../link/link.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
outline: solid 3px var(--colorsSemanticFocus500);
box-shadow: none;
`;
const StyledMenuFullscreen = exports.StyledMenuFullscreen = _styledComponents.default.div`
  position: fixed;
  top: 0;
  bottom: 0;

  ${({
  theme
}) => (0, _styledComponents.css)`
    z-index: ${theme.zIndex.fullScreenModal};
  `}

  ${({
  startPosition,
  transitionDuration
}) => (0, _styledComponents.css)`
    &.enter {
      visibility: hidden;
      ${startPosition}: -100%;
    }

    &.enter-active {
      visibility: visible;
      ${startPosition}: 0;
      transition: all ${transitionDuration}ms ease;
    }

    &.exit {
      visibility: visible;
      ${startPosition}: 0;
    }

    &.exit-active {
      visibility: hidden;
      ${startPosition}: -100%;
      transition: all ${transitionDuration}ms ease;
    }
  `}
`;
const StyledMenuModal = exports.StyledMenuModal = _styledComponents.default.div`
  height: 100vh;
  width: 100vw;
  outline: none;

  && {
    ${_link.StyledLink} {
      max-width: 100vw;
    }

    ${_link.StyledLink} > a,
    ${_link.StyledLink} > button,
    > div {
      font-size: var(--fontSizes200);
    }
  }

  ${({
  menuType,
  theme
}) => (0, _styledComponents.css)`
    background-color: ${_menu.default[menuType].background};

    && {
      ${_search.default} {
        ${_icon.default} {
          display: inline-flex;
          bottom: auto;
        }

        ${_button.default} {
          display: flex;
          line-height: normal;
          padding-bottom: 0;

          &:focus {
            border-bottom-right-radius: var(--borderRadius050);
            border-top-right-radius: var(--borderRadius050);

            ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
          }
        }
      }
    }
  `}

  ${_box.default} {
    &::-webkit-scrollbar {
      width: 16px;
    }
  }
`;
const StyledMenuFullscreenHeader = exports.StyledMenuFullscreenHeader = _styledComponents.default.div`
  height: 40px;

  ${_iconButton.default} {
    position: absolute;
    z-index: 1;
    right: 16px;
    top: 8px;
  }

  ${({
  menuType
}) => (0, _styledComponents.css)`
    background-color: ${_menu.default[menuType].submenuItemBackground};
  `}
`;
StyledMenuFullscreen.defaultProps = {
  theme: _themes.baseTheme
};
StyledMenuModal.defaultProps = {
  theme: _themes.baseTheme
};