"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MenuFullscreen = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _menuFullScreen = require("./menu-full-screen.style");
var _menu = require("../menu.style");
var _menu2 = _interopRequireDefault(require("../menu.context"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _box = _interopRequireDefault(require("../../box"));
var _iconButton = _interopRequireDefault(require("../../icon-button"));
var _icon = _interopRequireDefault(require("../../icon"));
var _portal = _interopRequireDefault(require("../../portal"));
var _focusTrap = _interopRequireDefault(require("../../../__internal__/focus-trap"));
var _menuDivider = _interopRequireDefault(require("../menu-divider/menu-divider.component"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
var _useModalAria = _interopRequireDefault(require("../../../hooks/__internal__/useModalAria"));
var _useModalManager = _interopRequireDefault(require("../../../hooks/__internal__/useModalManager"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MenuFullscreen = ({
  "aria-label": ariaLabel = "Fullscreen menu",
  "data-element": dataElement,
  "data-role": dataRole,
  children,
  isOpen = false,
  onClose,
  startPosition = "left",
  topModalOverride
}) => {
  const menuRef = (0, _react.useRef)(null);
  const modalRef = (0, _react.useRef)(null);
  const contentRef = (0, _react.useRef)(null);
  const isTopModal = (0, _useModalAria.default)(modalRef);
  const {
    menuType
  } = (0, _react.useContext)(_menu2.default);
  const isDarkVariant = ["dark", "black"].includes(menuType);
  const transitionDuration = 200;
  const locale = (0, _useLocale.default)();
  const flattenedChildren = _react.default.Children.toArray(children);
  const childArray = _react.default.Children.toArray(flattenedChildren.map((child, index) => {
    if (index < flattenedChildren.length - 1) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, child, /*#__PURE__*/_react.default.createElement(_menuDivider.default, null));
    }
    return child;
  }));
  const closeModal = (0, _react.useCallback)(ev => {
    if (onClose && _events.default.isEscKey(ev)) {
      ev.stopImmediatePropagation();
      onClose(ev);
    }
  }, [onClose]);
  (0, _useModalManager.default)({
    open: isOpen,
    closeModal,
    modalRef: menuRef,
    topModalOverride
  });
  return /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_portal.default, null, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
    nodeRef: menuRef,
    in: isOpen,
    timeout: transitionDuration,
    unmountOnExit: true
  }, /*#__PURE__*/_react.default.createElement(_menuFullScreen.StyledMenuFullscreen, {
    ref: menuRef,
    startPosition: startPosition,
    transitionDuration: transitionDuration
  }, /*#__PURE__*/_react.default.createElement(_focusTrap.default, {
    wrapperRef: modalRef,
    isOpen: isOpen
  }, /*#__PURE__*/_react.default.createElement(_menuFullScreen.StyledMenuModal, {
    "aria-label": ariaLabel,
    "aria-modal": isTopModal ? true : undefined,
    "data-component": "menu-fullscreen",
    "data-element": dataElement,
    "data-role": dataRole,
    menuType: menuType,
    ref: modalRef,
    role: "dialog",
    tabIndex: -1
  }, /*#__PURE__*/_react.default.createElement(_menuFullScreen.StyledMenuFullscreenHeader, {
    menuType: menuType
  }, /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    "aria-label": locale.menuFullscreen.ariaLabels.closeButton(),
    onClick: onClose,
    "data-element": "close"
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "close",
    color: isDarkVariant ? "--colorsYang100" : undefined
  }))), /*#__PURE__*/_react.default.createElement(_box.default, {
    overflowY: "auto",
    scrollVariant: isDarkVariant ? "dark" : "light",
    width: "100%",
    height: "calc(100% - 40px)"
  }, /*#__PURE__*/_react.default.createElement(_menu.StyledMenuWrapper, {
    "data-component": "menu",
    menuType: menuType,
    ref: contentRef,
    display: "flex",
    flexDirection: "column",
    role: "list",
    inFullscreenView: true
  }, /*#__PURE__*/_react.default.createElement(_menu2.default.Provider, {
    value: {
      inFullscreenView: true,
      menuType,
      inMenu: true,
      openSubmenuId: null,
      setOpenSubmenuId: /* istanbul ignore next */() => {}
    }
  }, childArray)))))))));
};
exports.MenuFullscreen = MenuFullscreen;
var _default = exports.default = MenuFullscreen;