import React from "react";
import type { TagProps } from "../../../__internal__/utils/helpers/tags";
export interface MenuFullscreenProps extends Omit<TagProps, "data-component"> {
    /** Accessible name that conveys the purpose of the menu   */
    "aria-label"?: string;
    /** The child elements to render */
    children?: React.ReactNode;
    /** Sets whether the component is open or closed */
    isOpen?: boolean;
    /** The start position for the component to open from */
    startPosition?: "left" | "right";
    /** A callback to be called when the close icon is clicked or enter is pressed when focused */
    onClose: (ev: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement> | KeyboardEvent) => void;
    /** Manually override the internal modal stacking order to set this as top */
    topModalOverride?: boolean;
}
export declare const MenuFullscreen: ({ "aria-label": ariaLabel, "data-element": dataElement, "data-role": dataRole, children, isOpen, onClose, startPosition, topModalOverride, }: MenuFullscreenProps) => React.JSX.Element;
export default MenuFullscreen;
