"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _menuDivider = _interopRequireDefault(require("./menu-divider.style"));
var _menu = _interopRequireDefault(require("../menu.context"));
var _menu2 = require("../menu.style");
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const MenuDivider = /*#__PURE__*/_react.default.forwardRef(({
  size = "default",
  ...rest
}, ref) => {
  const menuContext = (0, _react.useContext)(_menu.default);
  return /*#__PURE__*/_react.default.createElement(_menu2.StyledMenuItem, {
    inSubmenu: true
  }, /*#__PURE__*/_react.default.createElement(_menuDivider.default, _extends({
    size: size
  }, (0, _tags.default)("menu-divider", rest), {
    menuType: menuContext.menuType,
    ref: ref
  })));
});
if (process.env.NODE_ENV !== "production") {
  MenuDivider.propTypes = {
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "size": _propTypes.default.oneOf(["default", "large"])
  };
}
MenuDivider.displayName = "MenuDivider";
var _default = exports.default = MenuDivider;