"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSubmenuWrapper = exports.StyledSubmenu = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _scrollableBlock = _interopRequireDefault(require("../../../menu/scrollable-block/scrollable-block.style"));
var _themes = require("../../../../style/themes");
var _link = require("../../../link/link.style");
var _menu = require("../../menu.style");
var _box = _interopRequireDefault(require("../../../box/box.style"));
var _menuItem = _interopRequireDefault(require("../../menu-item/menu-item.style"));
var _icon = _interopRequireDefault(require("../../../icon/icon.style"));
var _menu2 = _interopRequireDefault(require("../../menu.config"));
var _menuSegmentTitle = require("../../menu-segment-title/menu-segment-title.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSubmenuWrapper = exports.StyledSubmenuWrapper = _styledComponents.default.div`
  position: relative;
  width: fit-content;
  max-width: inherit;

  ${({
  isSubmenuOpen,
  theme
}) => isSubmenuOpen && (0, _styledComponents.css)`
      z-index: ${theme.zIndex.popover};
    `}

  ${({
  inFullscreenView,
  menuType,
  asPassiveItem
}) => inFullscreenView && (0, _styledComponents.css)`
      width: 100%;

      ${asPassiveItem && menuType && (0, _styledComponents.css)`
        ${_menuItem.default} {
          outline: none;
          color: ${_menu2.default[menuType].title};
        }
      `}
    `}
`;
const StyledSubmenu = exports.StyledSubmenu = _styledComponents.default.ul`
  ${({
  menuType,
  submenuDirection,
  variant,
  inFullscreenView,
  maxHeight,
  applyFocusRadiusStyling
}) => (0, _styledComponents.css)`
    ${!inFullscreenView && menuType && (0, _styledComponents.css)`
      box-shadow: var(--boxShadow100);
      position: absolute;
      background-color: ${variant === "default" ? _menu2.default[menuType].submenuItemBackground : _menu2.default[menuType].background};
      a,
      button,
      ${_link.StyledLink} a,
      ${_link.StyledLink} button {
        width: 100%;
      }
    `}

    ${inFullscreenView && (0, _styledComponents.css)`
      ${_menu.StyledMenuItem} {
        width: 100%;
      }
    `}

    ${!inFullscreenView && (0, _styledComponents.css)`
      border-bottom-right-radius: var(--borderRadius100);
      border-bottom-left-radius: var(--borderRadius100);
      overflow-y: auto;
      ${maxHeight && `max-height: ${maxHeight};`}

      ${_menu.StyledMenuItem}:last-child a,
      ${_menu.StyledMenuItem}:last-child button,
      ${_menu.StyledMenuItem}:last-child > span,
      ${_menu.StyledMenuItem}:last-child > div {
        border-bottom-left-radius: var(--borderRadius100);
        border-bottom-right-radius: var(--borderRadius100);
      }

      & ${_menuSegmentTitle.StyledSegmentChildren} > ${_menu.StyledMenuItem}:last-of-type a,
      ${_menuSegmentTitle.StyledSegmentChildren} > ${_menu.StyledMenuItem}:last-of-type button,
      ${_menuSegmentTitle.StyledSegmentChildren} > ${_menu.StyledMenuItem}:last-of-type > span,
      ${_menuSegmentTitle.StyledSegmentChildren} > ${_menu.StyledMenuItem}:last-of-type > div {
        border-bottom-right-radius: var(--borderRadius000);
        border-bottom-left-radius: var(--borderRadius000);

        :focus {
          border-bottom-right-radius: ${applyFocusRadiusStyling ? "var(--borderRadius100)" : "var(--borderRadius000)"};
          border-bottom-left-radius: ${applyFocusRadiusStyling ? "var(--borderRadius100)" : "var(--borderRadius000)"};
        }
      }

      &&&& ${_scrollableBlock.default} {
        ${_box.default} {
          border-bottom-right-radius: var(--borderRadius000);
          border-bottom-left-radius: ${applyFocusRadiusStyling ? "var(--borderRadius100)" : "var(--borderRadius000)"};

          ${_menu.StyledMenuItem}:last-child ${_link.StyledLink}, ${_menu.StyledMenuItem}:last-child a,
          ${_menu.StyledMenuItem}:last-child button {
            border-bottom-right-radius: var(--borderRadius000);
            border-bottom-left-radius: ${applyFocusRadiusStyling ? "var(--borderRadius100)" : "var(--borderRadius000)"};
          }
        }
      }
    `}

    display: block;
    list-style: none;
    margin: 0;
    padding: 0;
    min-width: 100%;

    ${_menuItem.default}:after, ${_menuItem.default}:hover:after {
      display: none;
    }

    ${_menuItem.default} {
      display: flex;
      align-items: center;
      height: 40px;
      line-height: 40px;
      white-space: nowrap;
      cursor: pointer;

      ${!inFullscreenView && menuType && (0, _styledComponents.css)`
        background-color: ${_menu2.default[menuType].submenuItemBackground};

        > a:focus,
        > button:focus {
          background-color: ${_menu2.default[menuType].submenuItemBackground};
        }

        > a:hover,
        > button:hover {
          background-color: transparent;
          color: var(--colorsComponentsMenuYang100);

          > [data-component="icon"] {
            color: var(--colorsComponentsMenuYang100);
          }
        }
      `}

      a {
        text-decoration: none;
      }

      > ${_icon.default} {
        width: 16px;
        height: 16px;
        margin-right: 5px;
      }
    }

    [data-component="icon"] {
      line-height: 20px;

      &:before {
        line-height: unset;
      }

      span {
        vertical-align: middle;

        svg {
          height: 16px;
          width: 16px;
        }
      }
    }

    &:before {
      background-color: transparent;
      border-radius: 0 0 4px 4px;
      content: "";
      height: 5px;
      position: absolute;
      top: -5px;
      width: 100%;
    }

    ${submenuDirection === "left" && (0, _styledComponents.css)`
      right: 0;
    `}
  `}
`;
StyledSubmenuWrapper.defaultProps = {
  theme: _themes.baseTheme
};