"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _menuItem = _interopRequireDefault(require("../../menu-item/menu-item.style"));
var _submenu = require("./submenu.style");
var _events = _interopRequireDefault(require("../../../../__internal__/utils/helpers/events"));
var _menu = _interopRequireDefault(require("../../menu.context"));
var _keyboardNavigation = require("../keyboard-navigation");
var _submenu2 = _interopRequireDefault(require("./submenu.context"));
var _useClickAwayListener = _interopRequireDefault(require("../../../../hooks/__internal__/useClickAwayListener"));
var _guid = _interopRequireDefault(require("../../../../__internal__/utils/helpers/guid"));
var _locators = require("../locators");
var _useStableCallback = _interopRequireDefault(require("../../../../hooks/__internal__/useStableCallback/useStableCallback"));
var _fixedNavigationBar = _interopRequireDefault(require("../../../navigation-bar/fixed-navigation-bar.context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Submenu = /*#__PURE__*/_react.default.forwardRef(({
  children,
  className,
  title,
  icon,
  submenuDirection = "right",
  onKeyDown,
  variant = "default",
  showDropdownArrow = true,
  clickToOpen,
  href,
  maxWidth,
  asPassiveItem,
  onSubmenuOpen: onSubmenuOpenProp,
  onSubmenuClose,
  onClick,
  ...rest
}, ref) => {
  const [submenuRef, setSubmenuRef] = (0, _react.useState)(null);
  const submenuId = (0, _react.useRef)((0, _guid.default)());
  const menuContext = (0, _react.useContext)(_menu.default);
  const {
    inFullscreenView,
    openSubmenuId,
    setOpenSubmenuId,
    menuType
  } = menuContext;
  const [submenuOpen, setSubmenuOpen] = (0, _react.useState)(false);
  const [submenuFocusId, setSubmenuFocusId] = (0, _react.useState)(null);
  const [submenuItemIds, setSubmenuItemIds] = (0, _react.useState)([]);
  const [characterString, setCharacterString] = (0, _react.useState)("");
  const [applyFocusRadius, setApplyFocusRadius] = (0, _react.useState)(false);
  const shiftTabPressed = (0, _react.useRef)(false);
  const focusFirstMenuItemOnOpen = (0, _react.useRef)(false);
  const numberOfChildren = submenuItemIds.length;
  const {
    submenuMaxHeight
  } = (0, _react.useContext)(_fixedNavigationBar.default);
  const onSubmenuOpen = (0, _useStableCallback.default)(onSubmenuOpenProp);
  const blockIndex = (0, _react.useMemo)(() => {
    const items = submenuRef?.querySelectorAll(_locators.BLOCK_INDEX_SELECTOR);
    if (items && submenuOpen && numberOfChildren) {
      const childrenArray = Array.from(items);
      const scrollableBlock = submenuRef?.querySelector(`[data-component='${_locators.SCROLLABLE_BLOCK}']`);
      const index = scrollableBlock ? childrenArray.indexOf(scrollableBlock) : -1;
      return scrollableBlock?.querySelector(`[data-component='${_locators.SCROLLABLE_BLOCK_PARENT}']`) ? index + 1 : index;
    }
    return -1;
  }, [submenuOpen, numberOfChildren, submenuRef]);
  const characterTimer = (0, _react.useRef)(null);
  const startCharacterTimeout = (0, _react.useCallback)(() => {
    characterTimer.current = setTimeout(() => {
      setCharacterString("");
    }, 1500);
  }, []);
  const restartCharacterTimeout = (0, _react.useCallback)(() => {
    /* istanbul ignore else */
    if (characterTimer.current) {
      clearTimeout(characterTimer.current);
    }
    startCharacterTimeout();
  }, [startCharacterTimeout]);
  const openSubmenu = (0, _react.useCallback)(() => {
    setSubmenuOpen(true);
    setOpenSubmenuId(submenuId.current);
  }, [setOpenSubmenuId]);
  const lastMenuItemElement = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    const handleBorderRadiusStyling = () => {
      // Finds all ul elements that are not submenus
      const ulElements = Array.from(submenuRef?.querySelectorAll("ul:not([data-component='submenu'])") || /* istanbul ignore next */[]);

      // Terminate early if there are no ul elements as we have nothing we need to apply styles to.
      if (ulElements.length === 0) return;

      // Get the last menu item in the submenu
      const lastMenuItem = Array.from(submenuRef?.querySelectorAll("[data-component='menu-item']") || /* istanbul ignore next */[]).pop();
      lastMenuItemElement.current = lastMenuItem;

      // Get the last segment block
      const lastSegmentBlock = ulElements.pop();

      // Get all the menu items from the last segment block
      const segmentBlockMenuItems = Array.from(lastSegmentBlock?.querySelectorAll("[data-component='menu-item']") || /* istanbul ignore next */[]);

      // Get the last menu item in the last segment block
      const lastMenuItemInSegmentBlock = segmentBlockMenuItems.pop();
      // Check if the last item in the segment block is the same as the last MenuItem in the submenu
      const menuItemsMatch = !!lastMenuItemInSegmentBlock && lastMenuItemInSegmentBlock === lastMenuItem;
      setApplyFocusRadius(menuItemsMatch);
    };
    if (submenuOpen && submenuRef) {
      handleBorderRadiusStyling();
    }
  }, [submenuOpen, submenuRef]);
  (0, _react.useEffect)(() => {
    if (submenuOpen && onSubmenuOpen) {
      onSubmenuOpen();
    }
  }, [submenuOpen, onSubmenuOpen]);
  const closeSubmenu = (0, _react.useCallback)(() => {
    shiftTabPressed.current = false;
    setSubmenuOpen(false);
    setSubmenuFocusId(null);
    if (onSubmenuClose) {
      onSubmenuClose();
    }
    setCharacterString("");
  }, [onSubmenuClose]);
  (0, _react.useEffect)(() => {
    if (openSubmenuId && openSubmenuId !== submenuId.current) {
      closeSubmenu();
    }
  }, [openSubmenuId, closeSubmenu]);
  const findCurrentIndex = (0, _react.useCallback)(id => {
    const index = submenuItemIds.findIndex(itemId => itemId === id);
    return index;
  }, [submenuItemIds]);
  const handleKeyDown = (0, _react.useCallback)(event => {
    if (!submenuOpen) {
      if (_events.default.isEnterKey(event) || _events.default.isSpaceKey(event) || _events.default.isDownKey(event) || _events.default.isUpKey(event)) {
        event.preventDefault();
        openSubmenu();
        focusFirstMenuItemOnOpen.current = !href;
      }
    }
    if (submenuOpen) {
      const index = findCurrentIndex(submenuFocusId);
      let nextIndex = index;
      if (href && !submenuFocusId) {
        if (_events.default.isDownKey(event) || _events.default.isUpKey(event) || _events.default.isTabKey(event) && !_events.default.isShiftKey(event)) {
          event.preventDefault();
          setSubmenuFocusId(submenuItemIds[0]);
          return;
        }
      }
      if (_events.default.isTabKey(event) && !_events.default.isShiftKey(event)) {
        if (nextIndex === numberOfChildren - 1) {
          closeSubmenu();
          return;
        }
        shiftTabPressed.current = false;
        nextIndex += 1;
      }
      if (_events.default.isTabKey(event) && _events.default.isShiftKey(event)) {
        if (nextIndex <= 0) {
          closeSubmenu();
          return;
        }
        shiftTabPressed.current = true;
        nextIndex -= 1;
      }
      if (_events.default.isDownKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        if (nextIndex < numberOfChildren - 1) {
          nextIndex += 1;
        }
      }
      if (_events.default.isUpKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        setApplyFocusRadius(false);
        if (nextIndex > 0) {
          nextIndex -= 1;
        }
      }
      if (_events.default.isEscKey(event)) {
        onKeyDown?.(event);
        closeSubmenu();
        return;
      }
      if (_events.default.isHomeKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        nextIndex = 0;
      }
      if (_events.default.isEndKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        nextIndex = numberOfChildren - 1;
      }
      if (event.key.length === 1) {
        event.stopPropagation();
        shiftTabPressed.current = false;
        if (characterTimer.current) {
          restartCharacterTimeout();
        } else {
          startCharacterTimeout();
        }
        setCharacterString(`${characterString}${event.key.toLowerCase()}`);
      } else {
        setCharacterString("");
      }
      const eventIsFromInput = _events.default.composedPath(event).find(p => p.getAttribute("data-element") === "input" || p.getAttribute("data-element") === "input-icon-toggle");
      if (!eventIsFromInput) {
        if (_events.default.isEnterKey(event)) {
          /* timeout enforces that the "closeSubmenu" method will be run after 
            the browser navigates to the specified href of the menu-item. */
          setTimeout(() => closeSubmenu(), 0);
        }
        if (href && _events.default.isEnterKey(event)) {
          closeSubmenu();
          return;
        }
      }
      if (nextIndex !== index) {
        setSubmenuFocusId(submenuItemIds[nextIndex]);
      }
    }
  }, [submenuItemIds, submenuOpen, href, numberOfChildren, submenuFocusId, findCurrentIndex, openSubmenu, closeSubmenu, onKeyDown, characterString, restartCharacterTimeout, startCharacterTimeout]);
  (0, _react.useEffect)(() => {
    /* istanbul ignore else */
    if (submenuRef && children) {
      const items = submenuRef?.querySelectorAll(_locators.ALL_CHILDREN_SELECTOR);

      /* istanbul ignore else */
      if (items) {
        setSubmenuItemIds(Array.from(items).map(item => item.getAttribute("id")));
      }
    }
  }, [children, submenuOpen, submenuRef]);
  (0, _react.useEffect)(() => {
    if (focusFirstMenuItemOnOpen.current && submenuOpen && !submenuFocusId && submenuItemIds.length) {
      focusFirstMenuItemOnOpen.current = false;
      setSubmenuFocusId(submenuItemIds[0]);
    }
  }, [submenuOpen, submenuFocusId, submenuItemIds]);
  const handleClickAway = () => {
    document.removeEventListener("click", handleClickAway);
    closeSubmenu();
  };
  const handleClickInside = (0, _useClickAwayListener.default)(handleClickAway);
  const handleClick = event => {
    openSubmenu();
    if (onClick) {
      onClick(event);
    }
  };
  (0, _react.useEffect)(() => {
    const items = submenuRef?.querySelectorAll(_locators.ALL_CHILDREN_SELECTOR);
    if (items && characterString !== "") {
      const submenuChildren = Array.from(items);
      const nextItem = (0, _keyboardNavigation.characterNavigation)(characterString, submenuChildren);
      if (nextItem) {
        setSubmenuFocusId(nextItem.id);
      }
    }
  }, [submenuRef, characterString, submenuItemIds]);
  if (inFullscreenView) {
    return /*#__PURE__*/_react.default.createElement(_submenu.StyledSubmenuWrapper, {
      "data-component": "submenu-wrapper",
      inFullscreenView: inFullscreenView,
      asPassiveItem: asPassiveItem,
      menuType: menuContext.menuType,
      onClick: handleClickInside
    }, /*#__PURE__*/_react.default.createElement(_menuItem.default, _extends({}, rest, {
      onClick: asPassiveItem ? undefined : onClick,
      className: className,
      menuType: menuType,
      ref: ref,
      href: href,
      variant: variant,
      inFullscreenView: inFullscreenView,
      asDiv: asPassiveItem
    }), title), /*#__PURE__*/_react.default.createElement(_submenu.StyledSubmenu, {
      "data-component": "submenu",
      variant: variant,
      menuType: menuType,
      inFullscreenView: inFullscreenView,
      ref: setSubmenuRef,
      applyFocusRadiusStyling: false
    }, /*#__PURE__*/_react.default.createElement(_submenu2.default.Provider, {
      value: {
        handleKeyDown,
        blockIndex,
        updateFocusId: setSubmenuFocusId
      }
    }, children)));
  }
  return /*#__PURE__*/_react.default.createElement(_submenu.StyledSubmenuWrapper, {
    "data-component": "submenu-wrapper",
    onMouseOver: !clickToOpen ? () => openSubmenu() : undefined,
    onMouseLeave: () => closeSubmenu(),
    isSubmenuOpen: submenuOpen,
    onClick: handleClickInside,
    ref: setSubmenuRef
  }, /*#__PURE__*/_react.default.createElement(_menuItem.default, _extends({}, rest, {
    className: className,
    menuType: menuType,
    ref: ref,
    icon: icon,
    tabIndex: -1,
    variant: variant,
    isOpen: submenuOpen,
    hasSubmenu: true,
    showDropdownArrow: showDropdownArrow,
    onKeyDown: handleKeyDown,
    onClick: handleClick,
    clickToOpen: clickToOpen,
    href: href,
    maxWidth: maxWidth,
    "aria-expanded": submenuOpen
  }), title), submenuOpen && /*#__PURE__*/_react.default.createElement(_submenu.StyledSubmenu, {
    "data-component": "submenu",
    submenuDirection: submenuDirection,
    variant: variant,
    menuType: menuType,
    role: blockIndex === 0 ? "presentation" : "list",
    maxHeight: submenuMaxHeight,
    applyFocusRadiusStyling: applyFocusRadius
  }, /*#__PURE__*/_react.default.createElement(_submenu2.default.Provider, {
    value: {
      submenuFocusId,
      handleKeyDown,
      blockIndex,
      updateFocusId: setSubmenuFocusId,
      shiftTabPressed: shiftTabPressed.current
    }
  }, children)));
});
if (process.env.NODE_ENV !== "production") {
  Submenu.propTypes = {
    "ariaLabel": _propTypes.default.string,
    "asPassiveItem": _propTypes.default.bool,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "clickToOpen": _propTypes.default.bool,
    "href": _propTypes.default.string,
    "icon": _propTypes.default.string,
    "maxWidth": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "onClick": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onSubmenuClose": _propTypes.default.func,
    "onSubmenuOpen": _propTypes.default.func,
    "showDropdownArrow": _propTypes.default.bool,
    "submenuDirection": _propTypes.default.string,
    "title": _propTypes.default.string,
    "variant": _propTypes.default.oneOf(["alternate", "default"])
  };
}
Submenu.displayName = "submenu";
var _default = exports.default = Submenu;