import React from "react";
import { MaxWidthProps } from "styled-system";
import { VariantType } from "../../menu-item";
export interface SubmenuProps {
    /** Children elements */
    children: React.ReactNode;
    /** Custom className */
    className?: string;
    /**
     * * <a href="https://brand.sage.com/d/NdbrveWvNheA/foundations#/icons/icons" target="_blank">List of supported icons</a>
     *
     * Adds an icon to the menu item.
     * */
    icon?: string;
    /** Defines which direction the submenu will hang eg. left/right */
    submenuDirection?: string;
    /** A title for the menu item that has a submenu. */
    title?: string;
    /** onKeyDown handler */
    onKeyDown?: (event: React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** set the colour variant for a menuType */
    variant?: VariantType;
    /** Flag to display the dropdown arrow when an item has a submenu */
    showDropdownArrow?: boolean;
    /** When set the submenu opens by click instead of hover */
    clickToOpen?: boolean;
    /** The href to use for the menu item. */
    href?: string;
    /** Maximum width. Any valid CSS string */
    maxWidth?: MaxWidthProps["maxWidth"];
    /** Used to set a submenu parent to passive styling in MenuFullscreen */
    asPassiveItem?: boolean;
    /** Callback triggered when submenu opens. Only valid with submenu prop */
    onSubmenuOpen?: () => void;
    /** Callback triggered when submenu closes. Only valid with submenu prop */
    onSubmenuClose?: () => void;
    /** Callback triggered when the top-level menu item is clicked */
    onClick?: (event: React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLButtonElement>) => void;
    ariaLabel?: string;
}
declare const Submenu: React.ForwardRefExoticComponent<SubmenuProps & React.RefAttributes<HTMLAnchorElement & HTMLButtonElement & HTMLDivElement>>;
export default Submenu;
