"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.characterNavigation = characterNavigation;
exports.menuKeyboardNavigation = menuKeyboardNavigation;
var _events = _interopRequireDefault(require("../../../../__internal__/utils/helpers/events"));
var _locators = require("../locators");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function characterNavigation(inputString, focusableItems) {
  if (!inputString || !focusableItems) return undefined;
  const getInnerText = element => element?.textContent?.split("\n")?.map(text => text.trim()).join(" ");
  const getMenuText = element => getInnerText(element)?.toLowerCase();
  const matchingItem = focusableItems.find(item => {
    if (!item?.getAttribute("data-component")) return false;
    return [_locators.MENU_ITEM, _locators.SCROLLABLE_BLOCK_PARENT].includes(item.getAttribute("data-component")) && getMenuText(item)?.startsWith(inputString.toLowerCase());
  });
  return matchingItem;
}
function menuKeyboardNavigation(event, focusableItems) {
  if (_events.default.isHomeKey(event)) {
    event.preventDefault();
    return 0;
  }
  if (_events.default.isEndKey(event)) {
    event.preventDefault();
    return focusableItems.length - 1;
  }
  return undefined;
}