"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Loader = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../../style/utils");
var _useMediaQuery = _interopRequireDefault(require("../../hooks/useMediaQuery"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _loader = _interopRequireDefault(require("./loader.style"));
var _loaderSquare = _interopRequireDefault(require("./loader-square.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Loader = ({
  variant = "default",
  "aria-label": ariaLabel,
  size = "medium",
  isInsideButton,
  isActive = true,
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const reduceMotion = !(0, _useMediaQuery.default)("screen and (prefers-reduced-motion: no-preference)");
  const loaderSquareProps = {
    isInsideButton,
    isActive,
    size,
    variant
  };

  // FE-6368 has been raised for the below, changed hex values for design tokens (when added)
  return /*#__PURE__*/_react.default.createElement(_loader.default, _extends({
    "aria-label": ariaLabel || l.loader.loading(),
    role: "progressbar"
  }, (0, _tags.default)("loader", rest), (0, _utils.filterStyledSystemMarginProps)(rest)), reduceMotion ? l.loader.loading() : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ["#13A038", "#0092DB", "#8F49FE"].map(color => /*#__PURE__*/_react.default.createElement(_loaderSquare.default, _extends({
    key: color,
    backgroundColor: variant === "gradient" ? color : "var(--colorsActionMajor500)"
  }, loaderSquareProps)))));
};
exports.Loader = Loader;
var _default = exports.default = Loader;