import React from "react";
import { MarginProps } from "styled-system";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
import { StyledLoaderSquareProps } from "./loader-square.style";
export interface LoaderProps extends Omit<StyledLoaderSquareProps, "backgroundColor">, MarginProps, TagProps {
    /** Toggle between the default variant and gradient variant */
    variant?: string;
    /** Specify a custom accessible name for the Loader component */
    "aria-label"?: string;
}
export declare const Loader: ({ variant, "aria-label": ariaLabel, size, isInsideButton, isActive, ...rest }: LoaderProps) => React.JSX.Element;
export default Loader;
