"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const loaderAnimation = (0, _styledComponents.keyframes)`
  0%, 80%, 100% {
    opacity: 0;
    transform: scale(0);
  }
  40% {
    opacity: 1;
    transform: scale(1);
  }
`;
const getDimentions = (size, roundedCornersOptOut) => {
  let width;
  let marginRight;
  switch (size) {
    case "medium":
      width = "16px";
      marginRight = "8px";
      break;
    case "large":
      width = "20px";
      marginRight = "8px";
      break;
    default:
      width = "12px";
      marginRight = "6px";
  }
  return (0, _styledComponents.css)`
    width: ${width};
    height: ${width};
    margin-right: ${marginRight};
    ${!roundedCornersOptOut && "border-radius: var(--borderRadiusCircle);"}
  `;
};
const StyledLoaderSquare = _styledComponents.default.div`
  ${({
  size,
  isInsideButton,
  isActive,
  theme,
  backgroundColor
}) => (0, _styledComponents.css)`
    animation: ${loaderAnimation} 1s infinite ease-in-out both;
    background-color: ${backgroundColor};
    display: inline-block;
    ${getDimentions(size, theme.roundedCornersOptOut)}

    ${isInsideButton && (0, _styledComponents.css)`
      background-color: ${isActive ? "var(--colorsUtilityYang100)" : "var(--colorsSemanticNeutral500)"};
    `}

    &:nth-of-type(1) {
      animation-delay: 0s;
    }

    &:nth-of-type(2) {
      animation-delay: 0.2s;
    }

    &:nth-of-type(3) {
      animation-delay: 0.4s;
      margin-right: 0px;
    }
  `}
`;
StyledLoaderSquare.defaultProps = {
  size: "small",
  isInsideButton: false,
  isActive: true,
  theme: _base.default
};
var _default = exports.default = StyledLoaderSquare;