"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSpinnerWrapper = exports.StyledSpinnerCircleSvg = exports.StyledLabel = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _loaderSpinner = require("./loader-spinner.config");
var _typography = _interopRequireDefault(require("../typography"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const calculateColors = (isWheel, variant) => {
  switch (variant) {
    case "neutral":
      return isWheel ? "var(--colorsSemanticNeutral500)" : "var(--colorsSemanticNeutral200)";
    case "gradient-grey":
      return isWheel ? "#00D639" : "#0000001A";
    case "gradient-white":
      return isWheel ? "#00D639" : "var(--colorsActionMajorYang100)";
    case "inverse":
      return "var(--colorsActionMajorYang100)";
    default:
      return isWheel ? "var(--colorsActionMajor500)" : "var(--colorsActionMajor150)";
  }
};
const StyledSpinnerWrapper = exports.StyledSpinnerWrapper = _styledComponents.default.div`
  ${_styledSystem.margin}
  display: flex;
  flex-direction: ${({
  size
}) => size === "extra-small" ? "row" : "column"};
`;
const StyledLabel = exports.StyledLabel = (0, _styledComponents.default)(_typography.default)`
  ${({
  size
}) => (0, _styledComponents.css)`
      display: flex;
      justify-content: center;
      text-align: center;
      ${size === "extra-small" ? "margin-left: var(--spacing100)" : `margin-top: ${_loaderSpinner.LOADER_SPINNER_SIZE_PARAMS[size].labelMarginTop}px`};
    `}
`;
const StyledSpinnerCircleSvg = exports.StyledSpinnerCircleSvg = _styledComponents.default.svg`
  ${({
  size,
  isTracked,
  hasMotion,
  isGradientVariant,
  animationTime,
  variant
}) => {
  const dimensions = `${_loaderSpinner.LOADER_SPINNER_SIZE_PARAMS[size].wrapperDimensions}px`;
  return size && (0, _styledComponents.css)`
        height: ${dimensions};
        min-height: ${dimensions};

        circle[data-role="outer-arc"] {
          fill: transparent;
          stroke-width: ${_loaderSpinner.LOADER_SPINNER_SIZE_PARAMS[size].strokeWidth}px;
          stroke: ${calculateColors(false, variant)};
          ${variant === "inverse" && `stroke-opacity: 0.3`}
          cx: 12px;
          cy: 12px;
          r: 10px;
        }

        circle[data-role="inner-arc"] {
          fill: transparent;
          stroke-width: ${_loaderSpinner.LOADER_SPINNER_SIZE_PARAMS[size].strokeWidth}px;
          stroke: ${calculateColors(true, variant)};
          stroke-linecap: round;
          stroke-dasharray: 100px;
          stroke-dashoffset: 80px;
          transform-origin: 12px 12px 0px;
          cx: 12px;
          cy: 12px;
          r: 10px;
          transform: rotate(270deg);

          @keyframes gradientAnimation {
            0% {
              stroke: #00d639;
            }

            33% {
              stroke: #11afff;
            }

            66% {
              stroke: #8f49fe;
            }
          }

          @keyframes trackedAnimation {
            from {
              stroke-dasharray: 100;
              stroke-dashoffset: 100;
            }

            to {
              stroke-dasharray: 100;
              stroke-dashoffset: 20;
            }
          }

          @keyframes untrackedAnimation {
            0% {
              transform: rotate(0deg);
              stroke-dasharray: 100;
            }

            40% {
              stroke-dasharray: 80;
            }

            80% {
              stroke-dasharray: 100;
            }

            100% {
              transform: rotate(360deg);
            }
          }

          animation-name: ${isTracked && !isGradientVariant ? "trackedAnimation" : "untrackedAnimation"},
            ${variant === "gradient-grey" || variant === "gradient-white" && "gradientAnimation" ? "gradientAnimation" : "none"};
          ${hasMotion && `animation-duration: ${animationTime}s`};
          animation-timing-function: cubic-bezier(0.2, 0.1, 0.8, 1);
          animation-iteration-count: ${hasMotion ? "infinite" : "none"};
        `;
}};
`;