"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LoaderSpinner = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _loaderSpinner = require("./loader-spinner.style");
var _utils = require("../../style/utils");
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _useMediaQuery = _interopRequireDefault(require("../../hooks/useMediaQuery"));
var _typography = _interopRequireDefault(require("../typography"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const LoaderSpinner = ({
  spinnerLabel,
  size = "medium",
  showSpinnerLabel = true,
  variant = "action",
  isTracked = false,
  hasMotion = true,
  animationTime,
  ...rest
}) => {
  const locale = (0, _useLocale.default)();
  const reduceMotion = !(0, _useMediaQuery.default)("screen and (prefers-reduced-motion: no-preference)");
  const isLabelDark = variant !== "inverse" && variant !== "gradient-white";
  const renderSpinnerLabel = /*#__PURE__*/_react.default.createElement(_loaderSpinner.StyledLabel, {
    "data-role": "visible-label",
    variant: "span",
    fontWeight: "500",
    size: size,
    color: isLabelDark ? "var(--colorsUtilityYin090);" : "var(--colorsActionMajorYang100);",
    fontSize: size === "extra-large" ? "var(--sizing200)" : "var(--sizing175)",
    lineHeight: size === "extra-large" ? "var(--sizing300)" : "var(--sizing250)"
  }, spinnerLabel || locale.loaderSpinner.loading());
  const isGradientVariant = variant === "gradient-white" || variant === "gradient-grey";
  const calculateDefaultAnimationTime = () => {
    if (animationTime) {
      return animationTime;
    }
    return isGradientVariant ? 2 : 1;
  };
  return /*#__PURE__*/_react.default.createElement(_loaderSpinner.StyledSpinnerWrapper, _extends({
    size: size,
    role: "status"
  }, (0, _tags.default)("loader-spinner", rest), (0, _utils.filterStyledSystemMarginProps)(rest)), reduceMotion ? renderSpinnerLabel : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loaderSpinner.StyledSpinnerCircleSvg, {
    role: "presentation",
    size: size,
    variant: variant,
    hasMotion: hasMotion,
    isTracked: isTracked,
    isGradientVariant: isGradientVariant,
    animationTime: calculateDefaultAnimationTime(),
    viewBox: "0 0 24 24"
  }, /*#__PURE__*/_react.default.createElement("circle", {
    "data-role": "outer-arc"
  }), /*#__PURE__*/_react.default.createElement("circle", {
    "data-role": "inner-arc"
  })), showSpinnerLabel ? renderSpinnerLabel : /*#__PURE__*/_react.default.createElement(_typography.default, {
    "data-role": "hidden-label",
    variant: "span",
    screenReaderOnly: true
  }, spinnerLabel || locale.loaderSpinner.loading())));
};
exports.LoaderSpinner = LoaderSpinner;
var _default = exports.default = LoaderSpinner;