"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LoaderBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../../style/utils");
var _useMediaQuery = _interopRequireDefault(require("../../hooks/useMediaQuery"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _loaderBar = _interopRequireWildcard(require("./loader-bar.style"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const LoaderBar = ({
  size = "medium",
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const reduceMotion = !(0, _useMediaQuery.default)("screen and (prefers-reduced-motion: no-preference)");
  return /*#__PURE__*/_react.default.createElement(_loaderBar.StyledLoader, _extends({
    "aria-label": l.loader.loading(),
    role: "progressbar"
  }, (0, _tags.default)("loader-bar", rest), (0, _utils.filterStyledSystemMarginProps)(rest)), reduceMotion ? l.loader.loading() : /*#__PURE__*/_react.default.createElement(_loaderBar.default, {
    size: size
  }, /*#__PURE__*/_react.default.createElement(_loaderBar.InnerBar, {
    size: size
  })));
};
exports.LoaderBar = LoaderBar;
LoaderBar.DisplayName = "Loader Bar";
var _default = exports.default = LoaderBar;