"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledLink = exports.StyledContent = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _button = _interopRequireDefault(require("../button/button.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const colorMap = {
  light: variant => {
    let color = "var(--colorsActionMajor500)";
    let hoverColor = "var(--colorsActionMajor600)";
    if (variant === "negative") {
      color = "var(--colorsSemanticNegative500)";
      hoverColor = "var(--colorsSemanticNegative600)";
    } else if (variant === "neutral") {
      color = "var(--colorsActionMajorYin090)";
    }
    return {
      color,
      hoverColor,
      disabledColor: "var(--colorsActionMajorYin030)"
    };
  },
  dark: variant => {
    let color = "var(--colorsActionMajor350)";
    let hoverColor = "var(--colorsActionMajor450)";
    if (variant === "negative") {
      color = "var(--colorsSemanticNegative350)";
      hoverColor = "var(--colorsSemanticNegative450)";
    } else if (variant === "neutral") {
      color = "var(--colorsActionMinor100)";
    }
    return {
      color,
      hoverColor,
      disabledColor: "var(--colorsActionMajorYang030)"
    };
  }
};
const StyledLink = exports.StyledLink = _styledComponents.default.span`
  ${({
  isSkipLink,
  theme,
  iconAlign,
  hasContent,
  disabled,
  variant,
  isDarkBackground,
  isMenuItem,
  hasFocus
}) => {
  const colorMapKey = isDarkBackground ? "dark" : "light";
  const {
    color,
    hoverColor,
    disabledColor
  } = colorMap[colorMapKey](variant);
  return (0, _styledComponents.css)`
      ${isSkipLink && (0, _styledComponents.css)`
        a {
          position: absolute;
          padding-left: var(--spacing300);
          padding-right: var(--spacing300);
          line-height: 36px;
          left: -999em;
          z-index: ${theme.zIndex.aboveAll};
          box-shadow: inset 0 0 0 var(--spacing025) var(--colorsActionMajor500);
          border: var(--spacing025) solid var(--colorsUtilityYang100);
          font-size: var(--fontSizes200);
          color: var(--colorsUtilityYin090);

          &:hover {
            cursor: pointer;
            color: var(--colorsUtilityYin090);

            ${_icon.default} {
              color: var(--colorsActionMajor600);
            }
          }

          &:focus {
            background-color: var(--colorsUtilityYang100);
          }
        }

        a:focus {
          top: var(--spacing100);
          left: var(--spacing100);
        }
      `}

      ${!isSkipLink && (0, _styledComponents.css)`
        > a,
        > button {
          font-size: var(--fontSizes100);

          ${!disabled && (0, _styledComponents.css)`
            color: ${color};
            ${_icon.default} {
              color: ${color};
            }

            &:hover {
              color: ${hoverColor};

              > ${_icon.default} {
                color: ${hoverColor};
              }
            }

            &:focus {
              background-color: var(--colorsSemanticFocus250);
              border-radius: var(--borderRadius025);
            }
          `}

          ${disabled && (0, _styledComponents.css)`
            color: ${disabledColor};
            &:hover,
            &:focus {
              color: ${disabledColor};
            }
          `}
        }
      `}

      > a,
      > button {
        text-decoration: ${hasContent ? "underline" : "none"};
        ${isMenuItem && "display: inline-block;"}

        > ${_icon.default} {
          display: ${hasContent ? "inline-block" : "inline"};
          position: relative;
          vertical-align: middle;
          ${iconAlign === "left" && (0, _styledComponents.css)`
            margin-right: ${hasContent ? "var(--spacing050)" : 0};
          `}
          ${iconAlign === "right" && (0, _styledComponents.css)`
            margin-right: 0;
            margin-left: ${hasContent ? "var(--spacing100)" : 0};
          `}
        }

        &:hover {
          cursor: pointer;
        }

        &:focus {
          color: var(--colorsActionMajorYin090);
          outline: none;

          ${_icon.default} {
            color: var(--colorsActionMajorYin090);
          }
        }

        ${disabled && (0, _styledComponents.css)`
          &:hover,
          &:focus {
            cursor: not-allowed;
          }
        `}
      }

      ${!isSkipLink && !disabled && !theme.focusRedesignOptOut && hasFocus && (0, _styledComponents.css)`
        > a,
        > button {
          outline: none;
          text-decoration: none;
          border-bottom-left-radius: var(--borderRadius000);
          border-bottom-right-radius: var(--borderRadius000);
        }
        max-width: fit-content;
        box-shadow: 0 var(--spacing050) 0 0 var(--colorsUtilityYin090);
        border-bottom-left-radius: var(--borderRadius025);
        border-bottom-right-radius: var(--borderRadius025);
      `}

      > button, ${_button.default}:not(.search-button) {
        background-color: transparent;
        border: none;
        padding: 0;
      }
    `;
}}
`;
StyledLink.defaultProps = {
  theme: _base.default,
  disabled: false,
  hasContent: true
};
const StyledContent = exports.StyledContent = _styledComponents.default.span``;