declare type Variants = "default" | "negative" | "neutral";
export interface StyledLinkProps {
    /** The disabled state of the link. */
    disabled?: boolean;
    /** Which side of the link to the render the link. */
    iconAlign?: "left" | "right";
    /** Allows to create skip link */
    isSkipLink?: boolean;
    /** Sets the colour styling when component is rendered on a dark background */
    isDarkBackground?: boolean;
    /** Allows link styling to be updated for light or dark backgrounds */
    variant?: Variants;
    hasFocus?: boolean;
}
interface PrivateStyledLinkProps {
    hasContent: boolean;
    isMenuItem?: boolean;
}
declare const StyledLink: import("styled-components").StyledComponent<"span", any, StyledLinkProps & PrivateStyledLinkProps, never>;
declare const StyledContent: import("styled-components").StyledComponent<"span", any, {}, never>;
export { StyledLink, StyledContent };
