"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Link = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _icon = _interopRequireDefault(require("../icon"));
var _menu = _interopRequireDefault(require("../menu/menu.context"));
var _link = require("./link.style");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Link = exports.Link = /*#__PURE__*/_react.default.forwardRef(({
  children,
  className,
  onKeyDown,
  href,
  onClick,
  onMouseDown,
  icon,
  iconAlign = "left",
  isSkipLink,
  disabled,
  ariaLabel,
  rel,
  tooltipMessage,
  tooltipPosition,
  target,
  variant = "default",
  isDarkBackground,
  placeholderTabIndex,
  removeAriaLabelOnIcon,
  ...rest
}, ref) => {
  const [hasFocus, setHasFocus] = (0, _react.useState)(false);
  const l = (0, _useLocale.default)();
  const {
    inMenu
  } = (0, _react.useContext)(_menu.default);
  const renderLinkIcon = (currentAlignment = "left") => {
    const hasProperAlignment = icon && iconAlign === currentAlignment;
    return hasProperAlignment ? /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: icon,
      disabled: disabled,
      ariaLabel: removeAriaLabelOnIcon ? undefined : ariaLabel,
      tooltipMessage: tooltipMessage,
      tooltipPosition: tooltipPosition
    }) : null;
  };
  const ariaProps = (0, _react.useMemo)(() => {
    const restObject = rest;
    return Object.keys(restObject).filter(key => key.startsWith("aria")).reduce((obj, key) => {
      obj[key] = restObject[key];
      return obj;
    }, {});
  }, [rest]);
  const componentProps = {
    onKeyDown,
    onMouseDown,
    onClick,
    disabled,
    target,
    ref,
    href,
    rel,
    "aria-label": ariaLabel,
    ...ariaProps,
    onFocus: () => setHasFocus(true),
    onBlur: () => setHasFocus(false)
  };
  const buttonProps = {
    type: "button"
  };
  const createLinkBasedOnType = () => {
    let type = "a";
    if (onClick && !href) {
      type = "button";
    }
    return /*#__PURE__*/_react.default.createElement(type, type === "button" ? {
      ...componentProps,
      ...buttonProps
    } : {
      ...componentProps,
      ...(placeholderTabIndex && href === undefined && !onClick && {
        tabIndex: -1
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderLinkIcon(), /*#__PURE__*/_react.default.createElement(_link.StyledContent, null, isSkipLink ? l.link.skipLinkLabel() : children), renderLinkIcon("right")));
  };
  return /*#__PURE__*/_react.default.createElement(_link.StyledLink, _extends({
    isSkipLink: isSkipLink,
    disabled: disabled,
    className: className,
    iconAlign: iconAlign,
    hasContent: Boolean(children),
    variant: variant,
    isDarkBackground: isDarkBackground,
    isMenuItem: inMenu
  }, (0, _tags.default)("link", rest), isSkipLink && {
    "data-element": "skip-link"
  }, {
    hasFocus: hasFocus
  }), createLinkBasedOnType());
});
if (process.env.NODE_ENV !== "production") {
  Link.propTypes = {
    "aria-activedescendant": _propTypes.default.string,
    "aria-atomic": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-autocomplete": _propTypes.default.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-checked": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-colcount": _propTypes.default.number,
    "aria-colindex": _propTypes.default.number,
    "aria-colspan": _propTypes.default.number,
    "aria-controls": _propTypes.default.string,
    "aria-current": _propTypes.default.oneOfType([_propTypes.default.oneOf(["date", "false", "location", "page", "step", "time", "true"]), _propTypes.default.bool]),
    "aria-describedby": _propTypes.default.string,
    "aria-details": _propTypes.default.string,
    "aria-disabled": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-dropeffect": _propTypes.default.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": _propTypes.default.string,
    "aria-expanded": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-flowto": _propTypes.default.string,
    "aria-grabbed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-haspopup": _propTypes.default.oneOfType([_propTypes.default.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), _propTypes.default.bool]),
    "aria-hidden": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-invalid": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "grammar", "spelling", "true"]), _propTypes.default.bool]),
    "aria-keyshortcuts": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "aria-level": _propTypes.default.number,
    "aria-live": _propTypes.default.oneOf(["assertive", "off", "polite"]),
    "aria-modal": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiline": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiselectable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-orientation": _propTypes.default.oneOf(["horizontal", "vertical"]),
    "aria-owns": _propTypes.default.string,
    "aria-placeholder": _propTypes.default.string,
    "aria-posinset": _propTypes.default.number,
    "aria-pressed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-readonly": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-relevant": _propTypes.default.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-roledescription": _propTypes.default.string,
    "aria-rowcount": _propTypes.default.number,
    "aria-rowindex": _propTypes.default.number,
    "aria-rowspan": _propTypes.default.number,
    "aria-selected": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-setsize": _propTypes.default.number,
    "aria-sort": _propTypes.default.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": _propTypes.default.number,
    "aria-valuemin": _propTypes.default.number,
    "aria-valuenow": _propTypes.default.number,
    "aria-valuetext": _propTypes.default.string,
    "ariaLabel": _propTypes.default.string,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "hasFocus": _propTypes.default.bool,
    "href": _propTypes.default.string,
    "icon": _propTypes.default.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "iconAlign": _propTypes.default.oneOf(["left", "right"]),
    "isDarkBackground": _propTypes.default.bool,
    "isSkipLink": _propTypes.default.bool,
    "onClick": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "placeholderTabIndex": _propTypes.default.bool,
    "rel": _propTypes.default.string,
    "removeAriaLabelOnIcon": _propTypes.default.bool,
    "target": _propTypes.default.string,
    "tooltipMessage": _propTypes.default.string,
    "tooltipPosition": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "variant": _propTypes.default.oneOf(["default", "negative", "neutral"])
  };
}
Link.displayName = "Link";
var _default = exports.default = Link;