import React from "react";
import { IconType } from "../icon";
import { StyledLinkProps } from "./link.style";
export interface LinkProps extends StyledLinkProps, React.AriaAttributes {
    /** An href for an anchor tag. */
    href?: string;
    /** An icon to display next to the link. */
    icon?: IconType;
    /** Function called when the mouse is clicked. */
    onClick?: (ev: React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Function called when a key is pressed. */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Function called when a mouse down event triggers. */
    onMouseDown?: (ev: React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** A message to display as a tooltip to the link. */
    tooltipMessage?: string;
    /** Positions the tooltip with the link. */
    tooltipPosition?: "bottom" | "left" | "right" | "top";
    /** Child content to render in the link. */
    children?: React.ReactNode;
    /** Classes to apply to the component. */
    className?: string;
    /** Target property in which link should open ie: _blank, _self, _parent, _top */
    target?: string;
    /** Aria label for accessibility purposes */
    ariaLabel?: string;
    /** allows to set rel property in <a> tag */
    rel?: string;
    /** @ignore @private internal prop to be set when no href or onClick passed */
    placeholderTabIndex?: boolean;
    /** @ignore @private internal prop to be set when no aria-label should be specified */
    removeAriaLabelOnIcon?: boolean;
}
export declare const Link: React.ForwardRefExoticComponent<LinkProps & React.RefAttributes<HTMLButtonElement | HTMLLinkElement>>;
export default Link;
