"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledUrl = exports.StyledTitle = exports.StyledPreviewWrapper = exports.StyledLinkPreview = exports.StyledDescription = exports.StyledCloseIconWrapper = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _preview = require("../preview/preview.style");
var _previewPlaceholder = require("../preview/__internal__/preview-placeholder.style");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 2px var(--colorsSemanticFocus500);
  outline-offset: -1px;
`;
const StyledLinkPreview = exports.StyledLinkPreview = _styledComponents.default.a`
  display: flex;
  margin: 8px;
  text-decoration: none;
  outline: none;

  ${({
  as
}) => (0, _styledComponents.css)`
    border: 1px solid var(--colorsUtilityMajor050);
    border-radius: var(--borderRadius100);
    background-color: var(--colorsUtilityMajor025);
    color: var(--colorsUtilityYin090);

    ${as !== "div" && (0, _styledComponents.css)`
      :focus {
        ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
      }

      :hover {
        cursor: pointer;
        background-color: var(--colorsUtilityMajor100);
      }
    `}
  `}
`;
StyledLinkPreview.defaultProps = {
  theme: _base.default
};
const StyledCloseIconWrapper = exports.StyledCloseIconWrapper = _styledComponents.default.div`
  padding: 16px;
`;
const StyledPreviewWrapper = exports.StyledPreviewWrapper = _styledComponents.default.div`
  flex-grow: 1;
  padding: 16px;

  ${({
  isLoading
}) => !isLoading && (0, _styledComponents.css)`
      ${_preview.StyledPreview} {
        display: flex;
        flex-direction: column;
        height: 100%;
      }
    `}

  ${_previewPlaceholder.StyledPreviewPlaceholder}:first-of-type {
    margin-top: 8px;
  }

  ${_previewPlaceholder.StyledPreviewPlaceholder}:not(:first-of-type) {
    margin-top: 16px;
  }
`;
const StyledTitle = exports.StyledTitle = _styledComponents.default.div`
  white-space: nowrap;
  text-overflow: ellipsis;
  font-weight: 700;
  font-size: 14px;
  line-height: 21px;
`;
const StyledDescription = exports.StyledDescription = _styledComponents.default.div`
  > div {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
    font-weight: 400;
    font-size: 14px;
    line-height: 21px;
    padding-top: 4px;
  }

  flex-grow: 1;
`;
const StyledUrl = exports.StyledUrl = _styledComponents.default.div`
  white-space: nowrap;
  text-overflow: ellipsis;
  font-weight: 400;
  font-size: 14px;
  line-height: 21px;
  color: var(--colorsUtilityMajor400);
`;