"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LinkPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _linkPreview = require("./link-preview.style");
var _image = _interopRequireDefault(require("../image"));
var _preview = _interopRequireDefault(require("../preview"));
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon"));
var _placeholder = _interopRequireDefault(require("./__internal__/placeholder.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const SCHEME_SEPARATOR = "://";
const LinkPreview = ({
  as,
  description,
  image,
  isLoading,
  onClose,
  title,
  url,
  ...rest
}) => {
  const loadingState = isLoading || !url;
  const canRenderAsLink = !loadingState && as !== "div";
  const imageProps = () => {
    return {
      src: image?.url,
      alt: image?.alt || "Link preview image",
      height: "152px"
    };
  };
  const displayUrl = () => {
    if (url?.includes(SCHEME_SEPARATOR)) {
      const startIndex = url.indexOf(SCHEME_SEPARATOR) + SCHEME_SEPARATOR.length;
      return url.substring(startIndex);
    }
    return url;
  };
  const linkProps = canRenderAsLink ? {
    href: url,
    target: "_blank",
    rel: "noopener noreferrer"
  } : {};
  return /*#__PURE__*/_react.default.createElement(_linkPreview.StyledLinkPreview, _extends({
    as: loadingState ? "div" : as,
    tabIndex: loadingState || as === "div" ? -1 : 0
  }, linkProps, rest), imageProps().src ? /*#__PURE__*/_react.default.createElement(_image.default, imageProps()) : /*#__PURE__*/_react.default.createElement(_placeholder.default, null), /*#__PURE__*/_react.default.createElement(_linkPreview.StyledPreviewWrapper, {
    isLoading: loadingState
  }, /*#__PURE__*/_react.default.createElement(_preview.default, {
    loading: loadingState,
    lines: 4
  }, /*#__PURE__*/_react.default.createElement(_linkPreview.StyledTitle, null, title), /*#__PURE__*/_react.default.createElement(_linkPreview.StyledDescription, null, /*#__PURE__*/_react.default.createElement("div", null, description)), /*#__PURE__*/_react.default.createElement(_linkPreview.StyledUrl, null, displayUrl()))), onClose && as === "div" && /*#__PURE__*/_react.default.createElement(_linkPreview.StyledCloseIconWrapper, null, /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    "aria-label": "link preview close button",
    onClick: () => onClose(url)
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "close"
  }))));
};
exports.LinkPreview = LinkPreview;
LinkPreview.displayName = "LinkPreview";
var _default = exports.default = LinkPreview;