"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledPlaceHolder = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StyledPlaceHolder = exports.StyledPlaceHolder = _styledComponents.default.div`
  overflow: hidden;
  position: relative;
  height: 152px;
  min-width: 152px;
  background-color: var(--colorsUtilityMajor025);
  border-bottom-left-radius: var(--borderRadius100);
  border-top-left-radius: var(--borderRadius100);
`;
const Circle = _styledComponents.default.div`
  height: 22px;
  width: 22px;
  border-radius: 50%;
  background-color: var(--colorsUtilityMajor100);
  position: absolute;
  left: 22px;
  top: 30px;
`;
const Square = _styledComponents.default.div`
  height: 200px;
  width: 200px;
  transform: rotate(45deg);
  background-color: ${({
  color
}) => color};
  position: absolute;
  border-radius: 2%;
  top: ${({
  top
}) => top};
  left: ${({
  left
}) => left};
`;
const Placeholder = () => /*#__PURE__*/_react.default.createElement(StyledPlaceHolder, {
  "data-component": "link preview image placeholder"
}, /*#__PURE__*/_react.default.createElement(Circle, null), /*#__PURE__*/_react.default.createElement(Square, {
  color: "var(--colorsUtilityMajor050)",
  top: "120px",
  left: "-64px"
}), /*#__PURE__*/_react.default.createElement(Square, {
  color: "var(--colorsUtilityMajor150)",
  top: "96px",
  left: "16px"
}));
var _default = exports.default = Placeholder;