"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledInlineInput = exports.StyledContentContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _inputPresentation = _interopRequireDefault(require("../../__internal__/input/input-presentation.style"));
var _label = require("../../__internal__/label/label.style");
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const spacings = {
  none: 0,
  "extra-small": 8,
  small: 16,
  "medium-small": 20,
  medium: 24,
  "medium-large": 28,
  large: 32,
  "extra-large": 40
};
const StyledInlineInput = exports.StyledInlineInput = _styledComponents.default.div`
  flex: 1;

  ${({
  gutter
}) => gutter && (0, _styledComponents.css)`
      margin-bottom: 0;
      padding-left: ${spacings[gutter]}px;
    `}
`;
const StyledContentContainer = exports.StyledContentContainer = _styledComponents.default.div`
  display: flex;
  flex: ${({
  inputWidth
}) => inputWidth ? `0 0 ${inputWidth}%` : 1};

  ${({
  gutter
}) => gutter && (0, _styledComponents.css)`
      margin-bottom: 0;
      margin-left: -${spacings[gutter]}px;

      ${gutter === "none" && (0, _styledComponents.css)`
        ${StyledInlineInput} + ${StyledInlineInput} ${_inputPresentation.default} {
          border-left: none;
        }

        ${StyledInlineInput}:not(:first-of-type):not(:last-of-type) ${_inputPresentation.default} {
          border-radius: var(--borderRadius000);
        }

        ${StyledInlineInput}:first-of-type:not(:last-of-type) ${_inputPresentation.default} {
          border-top-right-radius: var(--borderRadius000);
          border-bottom-right-radius: var(--borderRadius000);
          border-top-left-radius: var(--borderRadius050);
          border-bottom-left-radius: var(--borderRadius050);
        }

        ${StyledInlineInput}:last-of-type:not(:first-of-type) ${_inputPresentation.default} {
          border-top-left-radius: var(--borderRadius000);
          border-bottom-left-radius: var(--borderRadius000);
          border-top-right-radius: var(--borderRadius050);
          border-bottom-right-radius: var(--borderRadius050);
        }
      `}
    `}
`;
const StyledInlineInputs = _styledComponents.default.div`
  ${_styledSystem.margin}

  display: ${({
  labelInline
}) => labelInline ? `flex` : `block`};
  align-items: center;

  ${_label.StyledLabelContainer} {
    width: auto;
    margin-bottom: ${({
  labelInline
}) => labelInline ? `0px` : `8px`};
    padding-right: 16px;
    flex: 0 0 ${({
  labelWidth
}) => labelWidth ? `${labelWidth}%` : "auto"};
  }

  input {
    width: 1px;
  }

  [data-component="carbon-select"] input {
    width: 30px;
  }
`;
StyledInlineInputs.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledInlineInputs;