import { InlineInputsProps } from "./inline-inputs.component";
declare type GutterOptions = "none" | "extra-small" | "small" | "medium-small" | "medium" | "medium-large" | "large" | "extra-large";
interface StyledInlineInputProps {
    /** Gutter prop gets passed down to Row component if false gutter value is "none" */
    gutter?: GutterOptions;
}
export interface StyledContentContainerProps extends StyledInlineInputProps {
    /** Width of the inline inputs container in percentage */
    inputWidth?: number;
}
export interface StyledInlineInputsProps extends StyledInlineInputProps {
    /** Width of a label in percentage */
    labelWidth?: number;
    /** @ignore @private */
    labelInline?: boolean;
}
declare const StyledInlineInput: import("styled-components").StyledComponent<"div", any, InlineInputsProps, never>;
declare const StyledContentContainer: import("styled-components").StyledComponent<"div", any, InlineInputsProps, never>;
declare const StyledInlineInputs: import("styled-components").StyledComponent<"div", any, InlineInputsProps, never>;
export { StyledContentContainer, StyledInlineInput };
export default StyledInlineInputs;
