import React from "react";
import { MarginProps } from "styled-system";
import { StyledContentContainerProps, StyledInlineInputsProps } from "./inline-inputs.style";
export interface InlineInputsProps extends MarginProps, StyledContentContainerProps, StyledInlineInputsProps {
    /** Breakpoint for adaptive label (inline label change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Children elements */
    children?: React.ReactNode;
    /** [Legacy prop] A custom class name for the component. */
    className?: string;
    /** The id of the corresponding input control for the label */
    htmlFor?: string;
    /** Defines the label text for the heading. */
    label?: string;
    /** Inline label alignment */
    labelAlign?: "left" | "right";
    /**
     * Custom label id, could be used in combination with aria-labelledby prop of each input,
     * to make them accesible for screen readers.
     */
    labelId?: string;
    /** Flag to configure component as mandatory. */
    required?: boolean;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
}
declare const InlineInputs: {
    ({ adaptiveLabelBreakpoint, label, labelAlign, labelId, htmlFor, children, className, gutter, inputWidth, labelInline, labelWidth, required, isOptional, ...rest }: InlineInputsProps): React.JSX.Element;
    displayName: string;
};
export default InlineInputs;
