"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledImage = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../style/themes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledImage = exports.StyledImage = _styledComponents.default.div.attrs(({
  src,
  children,
  hidden = false,
  position,
  top,
  right,
  bottom,
  left
}) => ({
  ...(src && {
    as: "img"
  }),
  children: src ? undefined : children,
  src,
  hidden,
  position,
  top,
  right,
  bottom,
  left
}))`
  ${_styledSystem.margin}
  ${_styledSystem.layout}
  ${_styledSystem.padding}

  ${({
  position,
  top,
  right,
  bottom,
  left
}) => (0, _styledComponents.css)`
    position: ${position};
    top: ${top};
    right: ${right};
    bottom: ${bottom};
    left: ${left};
  `}

  ${({
  as
}) => as !== "img" && (0, _styledComponents.css)`
      ${_styledSystem.background}
    `}
`;
StyledImage.defaultProps = {
  backgroundPosition: "center",
  backgroundRepeat: "no-repeat",
  backgroundSize: "cover",
  theme: _themes.baseTheme
};