/// <reference types="react" />
import { MarginProps, BackgroundProps, LayoutProps, PaddingProps } from "styled-system";
export declare type PositionProps = "absolute" | "fixed" | "relative" | "static" | "sticky";
export interface StyledImageProps extends BackgroundProps, LayoutProps, MarginProps, PaddingProps {
    /** HTML alt property to display when an img fails to load */
    alt?: string;
    /** Prop to specify if the image is decorative  */
    decorative?: boolean;
    /** Any valid file path, passing this will render the component as an img element */
    src?: string;
    /** HTML hidden property to indicate whether to remain hidden visually and from screen readers */
    hidden?: boolean;
    /** Children elements, will only render if component is a div element */
    children?: React.ReactNode;
    /** Any valid CSS string for position */
    position?: PositionProps;
    /** Any valid CSS string for top */
    top?: string;
    /** Any valid CSS string for right */
    right?: string;
    /** Any valid CSS string for bottom */
    bottom?: string;
    /** Any valid CSS string for left */
    left?: string;
}
declare const StyledImage: import("styled-components").StyledComponent<"div", any, {
    children: import("react").ReactNode;
    src: string | undefined;
    hidden: boolean;
    position: PositionProps | undefined;
    top: string | undefined;
    right: string | undefined;
    bottom: string | undefined;
    left: string | undefined;
    as?: string | undefined;
} & StyledImageProps, "hidden" | "children" | "as" | "left" | "right" | "bottom" | "top" | "src" | "position">;
export { StyledImage };
