"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Image = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _image = require("./image.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Image = ({
  alt,
  decorative = false,
  src,
  children,
  position,
  top,
  right,
  bottom,
  left,
  ...rest
}) => {
  !(!src || !children) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "The 'Image' component renders as an 'img' element when the 'src' prop is used and therefore does not accept children.") : (0, _invariant.default)(false) : void 0;
  !(!src || alt && typeof alt === "string" || decorative) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "Please use the 'decorative' prop if the 'alt' text should be an empty value or provide an 'alt' string when rendering the 'Image' component as an 'img' element.") : (0, _invariant.default)(false) : void 0;
  return /*#__PURE__*/_react.default.createElement(_image.StyledImage, _extends({
    alt: alt,
    decorative: decorative,
    src: src,
    position: position,
    top: top,
    right: right,
    bottom: bottom,
    left: left
  }, rest), children);
};
exports.Image = Image;
Image.displayName = "Image";
var _default = exports.default = Image;