"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _polished = require("polished");
var _styledSystem = require("styled-system");
var _iconUnicodes = _interopRequireDefault(require("./icon-unicodes"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _iconConfig = _interopRequireDefault(require("./icon-config"));
var _browserTypeCheck = _interopRequireWildcard(require("../../__internal__/utils/helpers/browser-type-check"));
var _color = _interopRequireDefault(require("../../style/utils/color"));
var _getColorValue = _interopRequireDefault(require("../../style/utils/get-color-value"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function adjustIconBgSize(fontSize, bgSize) {
  const sizeValues = {
    "extra-small": 1,
    small: 2,
    medium: 3,
    large: 4,
    "extra-large": 5
  };
  if (fontSize && bgSize) {
    const fontSizeValue = sizeValues[fontSize];
    const bgSizeValue = sizeValues[bgSize];
    if (bgSizeValue < fontSizeValue) {
      // eslint-disable-next-line no-console
      console.warn(`[WARNING - Icon] The "${bgSize}" \`bgSize\` is smaller than "${fontSize}" \`fontSize\`, the \`bgSize\` has been auto adjusted to a larger size.`);
      return _iconConfig.default.backgroundSize[fontSize];
    }
    return _iconConfig.default.backgroundSize[bgSize];
  }
  return bgSize ? _iconConfig.default.backgroundSize[bgSize] : undefined;
}
const oldFocusStyling = "outline: 2px solid var(--colorsSemanticFocus500);";
const StyledIcon = _styledComponents.default.span`
  ${({
  theme,
  color,
  bg,
  isInteractive,
  bgSize,
  bgShape,
  type,
  fontSize,
  disabled,
  hasTooltip
}) => {
  let finalColor;
  let finalHoverColor;
  let bgColor;
  let bgHoverColor;
  const adjustedBgSize = adjustIconBgSize(fontSize, bgSize);
  try {
    if (disabled) {
      finalColor = "var(--colorsYin030)";
      finalHoverColor = "var(--colorsYin030)";
    } else if (color) {
      const {
        color: renderedColor
      } = (0, _color.default)({
        color,
        theme
      });
      finalColor = renderedColor;
      finalHoverColor = (0, _polished.shade)(0.2, (0, _getColorValue.default)(renderedColor));
    } else {
      finalColor = "var(--colorsYin090)";
      finalHoverColor = "var(--colorsYin090)";
    }
    if (bg) {
      const {
        backgroundColor
      } = (0, _color.default)({
        bg,
        theme
      });
      bgColor = backgroundColor;
      bgHoverColor = (0, _polished.shade)(0.2, (0, _getColorValue.default)(backgroundColor));
    } else {
      bgColor = "transparent";
      bgHoverColor = "transparent";
    }
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error(e);
  }
  return (0, _styledComponents.css)`
      position: relative;
      color: ${finalColor};
      background-color: ${bgColor};
      vertical-align: middle;
      align-items: center;
      display: inline-flex;
      justify-content: center;
      height: ${adjustedBgSize};
      width: ${adjustedBgSize};
      ${bgShape ? `border-radius: ${_iconConfig.default.backgroundShape[bgShape]}` : ""};

      ${isInteractive && (0, _styledComponents.css)`
        &:hover {
          color: ${finalHoverColor};
          background-color: ${bgHoverColor};
        }
      `}

      &::before {
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;

        font-family: CarbonIcons;
        content: "${_iconUnicodes.default[type]}";
        font-style: normal;
        font-weight: normal;
        vertical-align: middle;

        ${fontSize && (0, _styledComponents.css)`
          font-size: ${_iconConfig.default.iconSize[fontSize]};
          line-height: ${_iconConfig.default.iconSize[fontSize]};
        `}

        ${type === "services" && (0, _browserTypeCheck.default)(window) && (0, _styledComponents.css)`
          margin-top: ${fontSize === "small" ? "-7px" : "-8px"};
        `}

        ${type === "services" && (0, _browserTypeCheck.isSafari)(navigator) && !(0, _browserTypeCheck.default)(window) && (0, _styledComponents.css)`
          margin-top: -6px;
        `}
        
        display: block;
      }

      ${hasTooltip && `
        :focus {
          ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : oldFocusStyling}
        }
      `}

      ${_styledSystem.margin}
    `;
}}
`;
StyledIcon.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledIcon;