import { ThemeObject } from "../../style/themes/base";
import { IconType } from "./icon-type";
export declare type BackgroundShape = "circle" | "rounded-rect" | "square";
export declare type BgSize = "extra-small" | "small" | "medium" | "large" | "extra-large";
export declare type FontSize = "small" | "medium" | "large" | "extra-large";
export interface StyledIconProps {
    /** Background colour, provide any color from palette or any valid css color value. */
    bg?: string;
    /** Background shape */
    bgShape?: BackgroundShape;
    /** Background size */
    bgSize?: BgSize;
    /**
     * @private
     * @ignore
     * Add classes to this component
     */
    className?: string;
    /** Icon colour, provide any color from palette or any valid css color value. */
    color?: string;
    /** Sets the icon in the disabled state */
    disabled?: boolean;
    /** Icon font size */
    fontSize?: FontSize;
    /**
     * Icon type
     *
     * The full list of types can be seen [here](https://github.com/Sage/carbon/blob/master/src/components/icon/icon-config.js).
     */
    type: IconType;
}
export interface StyledIconInternalProps {
    isInteractive?: boolean;
    hasTooltip?: boolean;
    theme?: ThemeObject;
}
declare const StyledIcon: import("styled-components").StyledComponent<"span", any, StyledIconProps & StyledIconInternalProps, never>;
export default StyledIcon;
