"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _themes = require("../../style/themes");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  background-color: transparent;
  outline: solid 3px var(--colorsSemanticFocus500);
  z-index: 1;
`;
const StyledIconButton = _styledComponents.default.button.attrs({
  type: "button"
})`
  ${({
  disabled
}) => (0, _styledComponents.css)`
    && {
      ${_styledSystem.space}
    }
    background: transparent;
    border: none;
    border-radius: var(--borderRadius050);

    &:focus {
      ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
    }

    &:hover {
      cursor: ${!disabled ? "pointer" : "not-allowed"};
    }

    &::-moz-focus-inner {
      border: none;
    }

    ${_icon.default} {
      ${disabled && (0, _styledComponents.css)`
        color: var(--colorsActionMinorYin030);
        background-color: transparent;
      `};
      position: relative;

      &:focus {
        border: none;
      }
    }
  `}
`;
StyledIconButton.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledIconButton;