import React from "react";
import { SpaceProps } from "styled-system";
import { IconProps } from "../icon";
export interface IconButtonProps extends SpaceProps {
    /** Prop to specify the aria-label of the icon-button component */
    "aria-label"?: string;
    /** Icon meant to be rendered, should be an Icon component */
    children: React.ReactElement<IconProps>;
    /** Callback triggered on blur */
    onBlur?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Callback triggered on focus */
    onFocus?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Callback triggered on mouse enter */
    onMouseEnter?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    /** Callback triggered on mouse leave */
    onMouseLeave?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    /** [DEPRECATED - use `onClick` instead] Action callback */
    onAction?: (e: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** Set the button to disabled */
    disabled?: boolean;
    /** Callback triggered on click */
    onClick?: (e: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
}
declare const IconButton: React.ForwardRefExoticComponent<IconButtonProps & React.RefAttributes<HTMLButtonElement>>;
export default IconButton;
