"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 2px var(--colorsSemanticFocus500);
`;
const StyledHelp = _styledComponents.default.div`
  background: none;
  cursor: default;
  border: none;
  outline: none;
  display: inline-block;
  vertical-align: middle;
  font-size: 14px;
  position: relative;
  margin-bottom: 0;
  margin-top: 0;
  text-decoration: none;

  ${_icon.default} {
    color: var(--colorsUtilityYin065);
  }

  ${({
  href
}) => href && (0, _styledComponents.css)`
      cursor: pointer;
    `}

  &:focus ${_icon.default},
  &:hover ${_icon.default} {
    color: var(--colorsUtilityYin090);
    text-decoration: none;
  }

  &:focus ${_icon.default} {
    border-radius: var(--borderRadius050);
    ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
  }

  ${_styledSystem.margin}
`;
StyledHelp.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledHelp;