import React from "react";
import { MarginProps } from "styled-system";
import { IconType } from "../icon";
import { TooltipPositions } from "../tooltip/tooltip.config";
export interface HelpProps extends MarginProps {
    /** Overrides the default 'as' attribute of the Help component */
    as?: keyof JSX.IntrinsicElements;
    /** Aria label */
    ariaLabel?: string;
    /** The message to be displayed within the tooltip */
    children?: React.ReactNode;
    /** [Legacy] A custom class name for the component. */
    className?: string;
    /** The unique id of the component (used with aria-describedby for accessibility) */
    helpId?: string;
    /** A path for the anchor */
    href?: string;
    /** A boolean received from IconWrapper */
    isFocused?: boolean;
    /** Overrides the default tabindex of the component */
    tabIndex?: number;
    /** Override background color of the Tooltip, provide any color from palette or any valid css color value. */
    tooltipBgColor?: string;
    /** Override font color of the Tooltip, provide any color from palette or any valid css color value. */
    tooltipFontColor?: string;
    /** Overrides the default flip behaviour of the Tooltip,
     *  must be an array containing some or all of ["top", "bottom", "left", "right"]
     * (see https://popper.js.org/docs/v2/modifiers/flip/#fallbackplacements)
     */
    tooltipFlipOverrides?: TooltipPositions[];
    /** Id passed to the tooltip container, used for accessibility purposes */
    tooltipId?: string;
    /** Position of tooltip relative to target */
    tooltipPosition?: TooltipPositions;
    /** Help Icon type */
    type?: IconType;
    [key: string]: any;
}
export declare const Help: {
    ({ as, ariaLabel, children, className, href, helpId, isFocused, tabIndex, tooltipBgColor, tooltipFontColor, tooltipFlipOverrides, tooltipId, tooltipPosition, type, ...rest }: HelpProps): JSX.Element;
    displayName: string;
};
export default Help;
