"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSubHeader = exports.StyledSeparator = exports.StyledHeadingTitle = exports.StyledHeadingPills = exports.StyledHeadingIcon = exports.StyledHeadingBackButton = exports.StyledHeading = exports.StyledHeaderHelp = exports.StyledHeaderContent = exports.StyledHeader = exports.StyledDivider = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _icon = _interopRequireDefault(require("../icon"));
var _icon2 = _interopRequireDefault(require("../icon/icon.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _help = _interopRequireDefault(require("../help"));
var _typography = _interopRequireDefault(require("../typography"));
var _hr = _interopRequireDefault(require("../hr"));
var _link = _interopRequireDefault(require("../link"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledHeading = exports.StyledHeading = _styledComponents.default.div`
  width: 100%;
  ${_styledSystem.margin}
`;
StyledHeading.defaultProps = {
  theme: _base.default
};
const StyledHeaderContent = exports.StyledHeaderContent = _styledComponents.default.div`
  display: inline-flex;
  align-items: flex-end;
`;
const oldFocusStyling = "outline: 3px solid var(--colorsSemanticFocus500);";
const StyledHeader = exports.StyledHeader = _styledComponents.default.div`
  ${({
  divider,
  subheader,
  hasBackLink
}) => (0, _styledComponents.css)`
    ${subheader && (0, _styledComponents.css)`
      margin-bottom: 16px;
    `}

    ${divider && (0, _styledComponents.css)`
      margin-bottom: 15px;
    `}

    ${divider && !subheader && (0, _styledComponents.css)`
      margin-bottom: 20px;
    `}

    ${hasBackLink && (0, _styledComponents.css)`
      display: grid;
      grid-template-columns: min-content auto;
    `}
  `}
`;
const StyledHeadingBackButton = exports.StyledHeadingBackButton = (0, _styledComponents.default)(_link.default)`
  margin-right: 5px;
  margin-top: 2px;

  a,
  button {
    margin: 0 1px 0 0;
    text-decoration: none;

    &:focus {
      background-color: transparent;
      ${({
  theme
}) => !theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : oldFocusStyling}
    }

    &:hover {
      ${_icon2.default} {
        color: var(--colorsActionMinor600);
      }
    }

    ${_icon2.default} {
      margin-right: 0;
      display: inline-flex;
      color: var(--colorsActionMinor500);
    }
  }
`;
StyledHeadingBackButton.defaultProps = {
  theme: _base.default
};
const StyledHeadingTitle = exports.StyledHeadingTitle = (0, _styledComponents.default)(_typography.default)`
  line-height: 32px;
  ${({
  withMargin
}) => withMargin ? (0, _styledComponents.css)`
          margin-right: 16px;
        ` : null}
`;
const StyledHeadingPills = exports.StyledHeadingPills = _styledComponents.default.span`
  line-height: 32px;
  display: inline-block;
  vertical-align: top;
`;
const StyledSubHeader = exports.StyledSubHeader = _styledComponents.default.div`
  margin-top: 5px;
  grid-row: 2;

  ${({
  hasBackLink
}) => hasBackLink && (0, _styledComponents.css)`
      grid-column: 2;
    `}

  ${({
  hasSeparator
}) => hasSeparator && (0, _styledComponents.css)`
      grid-row: 3;
      margin-top: 0px;
    `}
`;
const StyledHeadingIcon = exports.StyledHeadingIcon = (0, _styledComponents.default)(_icon.default)`
  height: 30px;

  &:before,
  &${_icon2.default}:before {
    font-size: 24px;
  }
`;
const StyledSeparator = exports.StyledSeparator = _styledComponents.default.hr`
  border-top: 2px solid var(--colorsUtilityMajor100);
  margin: 10px 0 8px;
  text-align: left;
  width: 50px;
`;
const StyledDivider = exports.StyledDivider = (0, _styledComponents.default)(_hr.default)`
  margin: 15px 0 20px;
`;
const StyledHeaderHelp = exports.StyledHeaderHelp = (0, _styledComponents.default)(_help.default)`
  display: inline-block;
  margin-left: -6px;
  margin-right: 16px;
  position: relative;
  top: -4px;
  height: 22px;
`;