"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Heading = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../../style/utils");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _heading = require("./heading.style");
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Heading = ({
  children,
  backLink,
  divider = true,
  help,
  helpAriaLabel,
  helpLink,
  pills,
  separator = false,
  subheader,
  subtitleId,
  headingType = "h1",
  title,
  titleId,
  ...rest
}) => {
  const getHelp = () => {
    return /*#__PURE__*/_react.default.createElement(_heading.StyledHeaderHelp, {
      "data-element": "help",
      tooltipPosition: "right",
      href: helpLink,
      ariaLabel: helpAriaLabel
    }, help);
  };
  const l = (0, _useLocale.default)();
  const getBackButton = () => {
    const backButtonProps = typeof backLink === "string" ? {
      href: backLink
    } : {
      onClick: backLink
    };
    return /*#__PURE__*/_react.default.createElement(_heading.StyledHeadingBackButton
    // this event allows an element to be focusable on click event on IE
    , _extends({
      "aria-label": l.heading.backLinkAriaLabel(),
      "data-element": "back",
      onMouseDown: e => e.currentTarget.focus()
    }, backButtonProps), /*#__PURE__*/_react.default.createElement(_heading.StyledHeadingIcon, {
      type: "chevron_left"
    }));
  };
  const getSubheader = () => {
    return /*#__PURE__*/_react.default.createElement(_heading.StyledSubHeader, {
      "data-element": "subtitle",
      id: subtitleId,
      hasBackLink: !!backLink,
      hasSeparator: separator
    }, subheader);
  };
  const getPills = () => {
    return /*#__PURE__*/_react.default.createElement(_heading.StyledHeadingPills, {
      "data-element": "pills"
    }, pills);
  };
  const marginProps = (0, _utils.filterStyledSystemMarginProps)(rest);
  const dataAttributes = {
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  return title ? /*#__PURE__*/_react.default.createElement(_heading.StyledHeading, _extends({}, (0, _tags.default)("heading", dataAttributes), marginProps), /*#__PURE__*/_react.default.createElement(_heading.StyledHeader, {
    "data-element": "header-container",
    divider: divider,
    subheader: !!subheader,
    hasBackLink: !!backLink
  }, backLink && getBackButton(), /*#__PURE__*/_react.default.createElement(_heading.StyledHeaderContent, null, /*#__PURE__*/_react.default.createElement(_heading.StyledHeadingTitle, {
    withMargin: !!pills || !!help,
    variant: headingType,
    "data-element": "title",
    id: titleId
  }, title), (help || helpLink) && getHelp(), pills && getPills()), separator && /*#__PURE__*/_react.default.createElement(_heading.StyledSeparator, null), subheader && getSubheader()), divider && /*#__PURE__*/_react.default.createElement(_heading.StyledDivider, {
    "data-element": "divider"
  }), children) : null;
};
exports.Heading = Heading;
var _default = exports.default = Heading;