"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSum = exports.generateGroups = void 0;
const toSum = (acc, i) => acc + i;
exports.toSum = toSum;
const generateGroups = (groups, rawValue) => {
  return groups.reduce((acc, group, index, src) => {
    const soFar = src.slice(0, index).reduce(toSum, 0);
    const toAdd = rawValue.slice(soFar, soFar + group);
    return toAdd ? [...acc, toAdd] : acc;
  }, []);
};
exports.generateGroups = generateGroups;