"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getSpacing = getSpacing;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getSpacing(prop) {
  if (typeof prop === "number") {
    switch (prop) {
      case 0:
        return "var(--spacing000)";
      case 1:
        return "var(--spacing100)";
      case 2:
        return "var(--spacing200)";
      case 3:
        return "var(--spacing300)";
      case 4:
        return "var(--spacing400)";
      case 5:
        return "var(--spacing500)";
      case 6:
        return "var(--spacing600)";
      case 7:
        return "var(--spacing700)";
      case 8:
        return "var(--spacing800)";
      case 9:
        return "var(--spacing900)";
      case 10:
        return "var(--spacing1000)";
      default:
        return "var(--spacing100)";
    }
  }
  return String(prop);
}
function responsiveGridItem(responsiveSettings) {
  return responsiveSettings.map(setting => {
    const {
      alignSelf,
      gridArea,
      gridColumn,
      gridRow,
      maxWidth,
      justifySelf,
      p,
      pl,
      pr,
      pt,
      pb
    } = setting;
    return (0, _styledComponents.css)`
      @media screen and (max-width: ${maxWidth}) {
        align-self: ${alignSelf || "stretch"};
        justify-self: ${justifySelf || "stretch"};
        grid-area: ${gridArea};
        grid-column: ${gridColumn};
        grid-row: ${gridRow};
        padding: ${getSpacing(p)};
        padding-left: ${getSpacing(pl)};
        padding-right: ${getSpacing(pr)};
        padding-top: ${getSpacing(pt)};
        padding-bottom: ${getSpacing(pb)};
      }
    `;
  });
}
const StyledGridItem = _styledComponents.default.div`
  margin: 0;
  ${_styledSystem.padding}

  ${({
  alignSelf,
  justifySelf,
  gridArea = "auto / 1 / auto / 13",
  gridColumn,
  gridRow,
  responsiveSettings
}) => (0, _styledComponents.css)`
    ${(0, _styledSystem.flexbox)({
  alignSelf,
  justifySelf
})}
    ${(0, _styledSystem.grid)({
  gridArea,
  gridColumn,
  gridRow
})};

    ${responsiveSettings && (0, _styledComponents.css)`
      ${responsiveGridItem(responsiveSettings)};
    `}
  `}
`;
var _default = exports.default = StyledGridItem;