"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _box = _interopRequireDefault(require("../box"));
var _navigationBar = _interopRequireDefault(require("../navigation-bar"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StyledLogo = (0, _styledComponents.default)(_box.default)`
  display: flex;
  align-items: center;
  margin-left: var(--spacing200);
  margin-right: var(--spacing300);

  & > * {
    max-height: 100%;
  }

  @media (min-width: 600px) {
    margin-left: var(--spacing300);
  }
  @media (min-width: 960px) {
    margin-left: var(--spacing400);
  }
  @media (min-width: 1260px) {
    margin-left: var(--spacing500);
  }
`;
const GlobalHeader = ({
  children,
  logo,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_navigationBar.default, _extends({
    isGlobal: true
  }, rest), logo && /*#__PURE__*/_react.default.createElement(StyledLogo, {
    "data-element": "global-header-logo-wrapper"
  }, logo), children);
};
GlobalHeader.displayName = "GlobalHeader";
var _default = exports.default = GlobalHeader;