"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledRightButtons = exports.StyledLeftButtons = exports.StyledFullWidthButtons = exports.StyledFormFooter = exports.StyledFormContent = exports.StyledForm = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _formField = _interopRequireDefault(require("../../__internal__/form-field/form-field.style"));
var _button = _interopRequireDefault(require("../button/button.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _search = _interopRequireDefault(require("../search/search.style"));
var _textarea = _interopRequireDefault(require("../textarea/textarea.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFormContent = exports.StyledFormContent = _styledComponents.default.div`
  ${({
  stickyFooter,
  isInModal
}) => (0, _styledComponents.css)`
    ${stickyFooter && (0, _styledComponents.css)`
      overflow-y: ${isInModal ? "auto" : "inherit"};
      flex: 1;
    `}
  `}
`;
const StyledFormFooter = exports.StyledFormFooter = _styledComponents.default.div`
  align-items: center;
  display: flex;

  ${({
  buttonAlignment
}) => buttonAlignment === "right" && (0, _styledComponents.css)`
      justify-content: flex-end;
    `}

  ${({
  stickyFooter,
  fullWidthButtons,
  isInModal
}) => (0, _styledComponents.css)`
    ${!stickyFooter && (0, _styledComponents.css)`
      margin-top: 48px;
    `}

    ${stickyFooter && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityYang100);
      box-shadow: 0 -4px 12px 0 rgba(0, 0, 0, 0.05);
      box-sizing: border-box;
      padding: 16px 32px;
      width: 100%;
      z-index: 1000;
      ${!isInModal && (0, _styledComponents.css)`
        position: sticky;
      `}
      bottom: 0;
    `}

    ${fullWidthButtons && (0, _styledComponents.css)`
      flex-direction: column;
      align-items: stretch;
    `}
  `}

  ${_styledSystem.padding}
`;
StyledFormFooter.defaultProps = {
  theme: _base.default
};

// Accounts for height of the header of Modal parent, the height form footer and some additional spacing
const HEIGHT_SPACING = 216;
const StyledForm = exports.StyledForm = _styledComponents.default.form`
  ${_styledSystem.space}

  ${({
  height
}) => height && (0, _styledComponents.css)`
      height: ${height};
    `}

  // field spacing is also applied to form field here so we need to override
  ${_search.default} ${_formField.default}, ${_textarea.default} ${_formField.default} {
    margin-bottom: var(--spacing000);
  }

  ${({
  stickyFooter,
  isInModal,
  isInSidebar
}) => stickyFooter && (0, _styledComponents.css)`
      display: flex;
      flex-direction: column;
      position: relative;

      ${isInModal && (0, _styledComponents.css)`
        max-height: calc(100vh - ${HEIGHT_SPACING}px);
      `}

      ${isInSidebar && (0, _styledComponents.css)`
        min-height: 100%;
      `}
    `}
`;
const StyledRightButtons = exports.StyledRightButtons = _styledComponents.default.div`
  display: flex;
  ${({
  fullWidthButtons
}) => fullWidthButtons ? `margin-left: 0px;` : `margin-left: 16px;`}
  ${({
  buttonAlignment
}) => buttonAlignment === "left" && "flex-grow: 1"};

  ${_button.default}:last-child {
    margin-right: 0;
  }
`;
const StyledFullWidthButtons = exports.StyledFullWidthButtons = _styledComponents.default.div`
  width: 100%;
  display: flex;
`;
const StyledLeftButtons = exports.StyledLeftButtons = _styledComponents.default.div`
  display: flex;
  justify-content: flex-end;
  ${({
  fullWidthButtons
}) => fullWidthButtons ? `margin-right: 0px;` : `margin-right: 16px;`}
  ${({
  buttonAlignment
}) => buttonAlignment === "right" && "flex-grow: 1"};

  ${_button.default}:last-child {
    margin-right: 0;
  }
`;
StyledForm.defaultProps = {
  theme: _base.default
};