"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Form = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _sidebar = require("../sidebar/sidebar.component");
var _modal = require("../modal/modal.component");
var _formSummary = _interopRequireDefault(require("./__internal__/form-summary.component"));
var _form = require("./form.style");
var _form2 = require("./form.config");
var _formSpacingProvider = _interopRequireDefault(require("../../__internal__/form-spacing-provider"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Form = ({
  children,
  saveButton,
  leftSideButtons,
  rightSideButtons,
  errorCount,
  warningCount,
  onSubmit,
  buttonAlignment = "right",
  stickyFooter,
  fieldSpacing = 3,
  noValidate = true,
  height,
  fullWidthButtons = false,
  footerPadding = {},
  ...rest
}) => {
  const {
    isInSidebar
  } = (0, _react.useContext)(_sidebar.SidebarContext);
  const {
    isInModal
  } = (0, _react.useContext)(_modal.ModalContext);
  const formRef = (0, _react.useRef)(null);
  const formFooterRef = (0, _react.useRef)(null);
  const hasPadding = !!Object.keys(footerPadding).length;
  const renderFooter = !!(saveButton || leftSideButtons || rightSideButtons || errorCount || warningCount);
  const classNames = `${stickyFooter ? "sticky" : ""} ${hasPadding ? "padded" : ""}`.trimEnd();
  return /*#__PURE__*/_react.default.createElement(_form.StyledForm, _extends({
    ref: formRef,
    stickyFooter: stickyFooter,
    onSubmit: onSubmit,
    "data-component": "form",
    fieldSpacing: fieldSpacing,
    noValidate: noValidate,
    isInSidebar: isInSidebar,
    height: height,
    isInModal: isInModal
  }, rest), /*#__PURE__*/_react.default.createElement(_form.StyledFormContent, {
    "data-element": "form-content",
    className: stickyFooter ? "sticky" : "",
    stickyFooter: stickyFooter,
    isInModal: isInModal
  }, /*#__PURE__*/_react.default.createElement(_formSpacingProvider.default, {
    marginBottom: _form2.formSpacing[fieldSpacing]
  }, children)), !fullWidthButtons && renderFooter && /*#__PURE__*/_react.default.createElement(_form.StyledFormFooter, _extends({
    "data-element": "form-footer",
    className: classNames,
    ref: formFooterRef,
    stickyFooter: stickyFooter,
    buttonAlignment: buttonAlignment,
    isInModal: isInModal
  }, footerPadding), leftSideButtons && /*#__PURE__*/_react.default.createElement(_form.StyledLeftButtons, {
    buttonAlignment: buttonAlignment
  }, leftSideButtons), /*#__PURE__*/_react.default.createElement(_formSummary.default, {
    errorCount: errorCount,
    warningCount: warningCount
  }, saveButton), rightSideButtons && /*#__PURE__*/_react.default.createElement(_form.StyledRightButtons, {
    buttonAlignment: buttonAlignment
  }, rightSideButtons)), fullWidthButtons && renderFooter && /*#__PURE__*/_react.default.createElement(_form.StyledFormFooter, _extends({
    "data-element": "form-footer",
    className: classNames,
    ref: formFooterRef,
    stickyFooter: stickyFooter,
    buttonAlignment: buttonAlignment,
    fullWidthButtons: fullWidthButtons
  }, footerPadding), leftSideButtons && /*#__PURE__*/_react.default.createElement(_form.StyledLeftButtons, {
    fullWidthButtons: fullWidthButtons
  }, leftSideButtons), rightSideButtons && /*#__PURE__*/_react.default.createElement(_form.StyledRightButtons, {
    fullWidthButtons: fullWidthButtons
  }, rightSideButtons), /*#__PURE__*/_react.default.createElement(_form.StyledFullWidthButtons, null, /*#__PURE__*/_react.default.createElement(_formSummary.default, {
    fullWidth: fullWidthButtons,
    errorCount: errorCount,
    warningCount: warningCount
  }, saveButton))));
};
exports.Form = Form;
Form.displayName = "Form";
var _default = exports.default = Form;