"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledMessagePrefix = exports.StyledInternalSummary = exports.StyledFormSummary = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
var _button = _interopRequireDefault(require("../../button/button.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFormSummary = exports.StyledFormSummary = _styledComponents.default.div`
  display: inline-flex;
  align-items: center;
  font-size: 13px;
  font-weight: 700;
  margin: -8px;
  padding: 8px;
  white-space: nowrap;

  ${({
  fullWidth
}) => fullWidth && (0, _styledComponents.css)`
      display: flex;
      flex-wrap: wrap;
      width: 100%;
      justify-content: flex-start;
    `}

  ${({
  showSummary
}) => showSummary && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityMajor025);
    `}
  ${_button.default} {
    margin-right: 0;
  }
`;
const StyledMessagePrefix = exports.StyledMessagePrefix = _styledComponents.default.div`
  &:first-of-type {
    margin-left: 4px;
  }
  margin-right: 4px;
`;
const StyledInternalSummary = exports.StyledInternalSummary = _styledComponents.default.div`
  display: flex;
  align-items: center;
  margin-right: 8px;
  &:last-of-type {
    margin-right: 16px;
  }
  ${({
  type
}) => type === "warning" && (0, _styledComponents.css)`
      color: var(--colorsSemanticCaution650);
    `}
  ${({
  type
}) => type === "error" && (0, _styledComponents.css)`
      color: var(--colorsSemanticNegative600);
    `}

  ${_icon.default} {
    margin-right: 4px;
    ${({
  type
}) => type === "warning" && (0, _styledComponents.css)`
        color: var(--colorsSemanticCaution650);
      `}
    ${({
  type
}) => type === "error" && (0, _styledComponents.css)`
        color: var(--colorsSemanticNegative600);
      `}
  }
`;