"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Summary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _formSummary = require("./form-summary.style");
var _icon = _interopRequireDefault(require("../../icon"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Summary = ({
  type,
  errorCount = 0,
  warningCount = 0
}) => {
  const l = (0, _useLocale.default)();
  const messages = {
    errorCount,
    warningCount
  };
  const message = (0, _react.useMemo)(() => l.errors.messages.formSummary(errorCount, warningCount, type), [l.errors.messages, errorCount, warningCount, type]);
  if (messages[`${type}Count`]) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_formSummary.StyledMessagePrefix, null, message?.[0]), /*#__PURE__*/_react.default.createElement(_formSummary.StyledInternalSummary, {
      type: type,
      "data-element": `${type}s`
    }, /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: type
    }), /*#__PURE__*/_react.default.createElement("span", null, message?.[1])));
  }
  return null;
};
exports.Summary = Summary;
const FormSummary = ({
  fullWidth,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_formSummary.StyledFormSummary, {
    showSummary: !!(props.errorCount || props.warningCount),
    "data-element": "form-summary",
    fullWidth: fullWidth
  }, /*#__PURE__*/_react.default.createElement(Summary, _extends({
    type: "error"
  }, props)), /*#__PURE__*/_react.default.createElement(Summary, _extends({
    type: "warning"
  }, props)), props.children);
};
var _default = exports.default = FormSummary;