"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSpaceHolder = exports.StyledSortIcon = exports.StyledSort = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _icon = _interopRequireDefault(require("../../icon"));
var _addFocusStyling = _interopRequireDefault(require("../../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const oldFocusStyling = `
  outline: solid 1px var(--colorsSemanticFocus500);
`;
const StyledSort = exports.StyledSort = _styledComponents.default.div`
  display: inline-flex;
  align-items: center;
  padding-left: 2px;
  padding-right: 2px;
  border-bottom: 1px solid transparent;
  position: relative;

  :hover {
    border-bottom: 1px solid;
    cursor: pointer;
  }

  :focus {
    ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
    border-radius: var(--borderRadius025);
  }
`;
StyledSort.defaultProps = {
  theme: _base.default
};
const StyledSpaceHolder = exports.StyledSpaceHolder = _styledComponents.default.div`
  display: inline-block;
  width: 22px;
`;
const StyledSortIcon = exports.StyledSortIcon = (0, _styledComponents.default)(_icon.default)`
  padding-left: var(--spacing075);
  color: ${({
  iconColor
}) => `var(${iconColor})`};
`;