"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Sort = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _typography = _interopRequireDefault(require("../../typography"));
var _sort = require("./sort.style");
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
var _flatTable = require("../flat-table.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Sort = ({
  children,
  onClick,
  sortType,
  accessibleName
}) => {
  const id = (0, _react.useRef)((0, _guid.default)());
  const locale = (0, _useLocale.default)();
  const onKeyDown = e => {
    if (_events.default.isEnterOrSpaceKey(e)) {
      e.preventDefault();
      return onClick?.();
    }
    return null;
  };
  const {
    colorTheme
  } = (0, _react.useContext)(_flatTable.FlatTableThemeContext);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_typography.default, {
    screenReaderOnly: true,
    id: id.current
  }, accessibleName || locale.sort.accessibleName(children, sortType)), /*#__PURE__*/_react.default.createElement(_sort.StyledSort, {
    role: "button",
    onKeyDown: onKeyDown,
    tabIndex: 0,
    onClick: onClick,
    sortType: sortType,
    "aria-labelledby": id.current
  }, children, sortType && /*#__PURE__*/_react.default.createElement(_sort.StyledSortIcon, {
    type: sortType === "ascending" ? "sort_up" : "sort_down",
    iconColor: colorTheme === "dark" ? "--colorsActionMinorYang100" : "--colorActionMinor500"
  })), !sortType && /*#__PURE__*/_react.default.createElement(_sort.StyledSpaceHolder, null));
};
exports.Sort = Sort;
var _default = exports.default = Sort;