"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledTableContainer = exports.StyledFlatTableWrapper = exports.StyledFlatTableFooter = exports.StyledFlatTable = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _flatTableHeader = _interopRequireDefault(require("./flat-table-header/flat-table-header.style"));
var _flatTableRow = _interopRequireDefault(require("./flat-table-row/flat-table-row.style"));
var _flatTableRowHeader = require("./flat-table-row-header/flat-table-row-header.style");
var _flatTableHead = _interopRequireDefault(require("./flat-table-head/flat-table-head.style"));
var _flatTableCheckbox = _interopRequireDefault(require("./flat-table-checkbox/flat-table-checkbox.style"));
var _themes = require("../../style/themes");
var _flatTableCell = require("./flat-table-cell/flat-table-cell.style");
var _cellSizes = _interopRequireDefault(require("./cell-sizes.style"));
var _box = _interopRequireDefault(require("../box/box.style"));
var _pager = require("../pager/pager.style");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HEADER_OVERLAY_INCREMENT = 3;
const STICKY_FOOTER_OVERLAY_INCREMENT = 1;
const ROW_HEADER_OVERLAY_INCREMENT = 5;
const oldFocusStyling = `
  outline: 2px solid var(--colorsSemanticFocus500);
`;
const StyledTableContainer = exports.StyledTableContainer = _styledComponents.default.div`
  ${({
  width,
  overflowX
}) => width && (0, _styledComponents.css)`
      width: ${width};

      ${overflowX && `overflow-x: ${overflowX};`}
    `}

  :focus {
    outline: none;
  }
`;
const StyledFlatTable = exports.StyledFlatTable = _styledComponents.default.table`
  border-collapse: separate;
  border-spacing: 0;
  width: 100%;

  @-moz-document url-prefix() {
    overflow: hidden;
    border-top-left-radius: var(--borderRadius100);
    border-top-right-radius: var(--borderRadius100);
  }

  ${({
  caption
}) => caption && (0, _styledComponents.css)`
      caption {
        clip: rect(1px, 1px, 1px, 1px);
        height: 1px;
        overflow: hidden;
        width: 1px;
        position: absolute;
        top: -99999px;
      }
    `}

  ${({
  size
}) => {
  const {
    height,
    fontSize,
    paddingSize
  } = _cellSizes.default[size];
  return (0, _styledComponents.css)`
      ${_flatTableRow.default} {
        height: ${height};
      }

      ${_flatTableCell.StyledFlatTableCell} > div,
      ${_flatTableHeader.default} > div,
      ${_flatTableRowHeader.StyledFlatTableRowHeader} > div,
      ${_flatTableCheckbox.default} > div {
        font-size: ${fontSize};
        padding-left: ${paddingSize};
        padding-right: ${paddingSize};
      }
    `;
}}

  ${({
  isZebra
}) => isZebra && (0, _styledComponents.css)`
      ${_flatTableRow.default}:nth-child(2n) {
        ${_flatTableRowHeader.StyledFlatTableRowHeader},
        ${_flatTableCell.StyledFlatTableCell},
        ${_flatTableCheckbox.default} {
          background-color: var(--colorsUtilityMajor010);
        }
      }
      ${_flatTableRow.default}:hover {
        ${_flatTableCell.StyledFlatTableCell},
        ${_flatTableRowHeader.StyledFlatTableRowHeader},
        ${_flatTableCheckbox.default}:not(th) {
          background-color: var(--colorsUtilityMajor025);
        }
      }
    `}
`;
const StyledFlatTableWrapper = exports.StyledFlatTableWrapper = (0, _styledComponents.default)(_box.default)`
  border-top-left-radius: var(--borderRadius100);
  border-top-right-radius: var(--borderRadius100);
  ${({
  hasStickyFooter,
  hasHorizontalScrollbar
}) => !hasStickyFooter && !hasHorizontalScrollbar && (0, _styledComponents.css)`
      border-bottom-left-radius: var(--borderRadius100);
      border-bottom-right-radius: var(--borderRadius100);
    `}

  ${({
  isInSidebar,
  theme,
  isFocused
}) => (0, _styledComponents.css)`
      box-sizing: border-box;

      /* istanbul ignore next */
      ${theme.focusRedesignOptOut && isFocused && /* istanbul ignore next */
(0, _styledComponents.css)`
        ${oldFocusStyling}
      `}

      ${!theme.focusRedesignOptOut && isFocused && (0, _styledComponents.css)`
        ${(0, _addFocusStyling.default)()}
      `}

      ${isInSidebar ? "min-width: fit-content;" : ""}
    `}

  ${({
  colorTheme
}) => {
  switch (colorTheme) {
    case "light":
      return (0, _styledComponents.css)`
          ${_flatTableHeader.default},
          ${_flatTableHead.default} ${_flatTableCheckbox.default} {
            background-color: var(--colorsUtilityMajor100);
            border-right: 1px solid var(--colorsUtilityMajor150);
            border-bottom-color: var(--colorsUtilityMajor150);
          }
          ${_flatTableHead.default} ${_flatTableRowHeader.StyledFlatTableRowHeader} {
            background-color: var(--colorsUtilityMajor100);
            border-bottom-color: var(--colorsUtilityMajor150);
            border-right-color: var(--colorsUtilityMajor150);
            border-left-color: var(--colorsUtilityMajor150);
          }
        `;
    case "transparent-base":
      return (0, _styledComponents.css)`
          ${_flatTableHeader.default},
          ${_flatTableHead.default} ${_flatTableCheckbox.default} {
            background-color: var(--colorsUtilityMajor025);
            border-right: 1px solid var(--colorsUtilityMajor025);
            border-bottom-color: var(--colorsUtilityMajor100);
          }
          ${_flatTableHead.default} ${_flatTableRowHeader.StyledFlatTableRowHeader} {
            background-color: var(--colorsUtilityMajor025);
            border-bottom-color: var(--colorsUtilityMajor100);
            border-right-color: var(--colorsUtilityMajor025);
            border-left-color: var(--colorsUtilityMajor025);
          }
        `;
    case "transparent-white":
      return (0, _styledComponents.css)`
          ${_flatTableHeader.default},
          ${_flatTableHead.default} ${_flatTableCheckbox.default} {
            background-color: var(--colorsUtilityYang100);
            border-right: 1px solid var(--colorsUtilityYang100);
            border-bottom-color: var(--colorsUtilityMajor100);
          }
          ${_flatTableHead.default} ${_flatTableRowHeader.StyledFlatTableRowHeader} {
            background-color: var(--colorsUtilityYang100);
            border-bottom-color: var(--colorsUtilityMajor100);
            border-right-color: var(--colorsUtilityYang100);
            border-left-color: var(--colorsUtilityYang100);
          }
        `;
    // default theme is "dark"
    default:
      return (0, _styledComponents.css)`
          ${_flatTableHead.default} ${_flatTableCheckbox.default},
          ${_flatTableHeader.default},
          ${_flatTableHead.default} {
            background-color: var(--colorsUtilityMajor400);
            border-right: 1px solid var(--colorsUtilityMajor300);
            color: var(--colorsUtilityYang100);
            border-bottom-color: var(--colorsUtilityMajor300);
          }
          ${_flatTableHead.default} ${_flatTableRowHeader.StyledFlatTableRowHeader} {
            background-color: var(--colorsUtilityMajor400);
            color: var(--colorsUtilityYang100);
            border-bottom-color: var(--colorsUtilityMajor300);
            border-right-color: var(--colorsUtilityMajor300);
            border-left-color: var(--colorsUtilityMajor300);
          }
        `;
  }
}}

  ${({
  isInSidebar
}) => isInSidebar && (0, _styledComponents.css)`
      ${_flatTableHead.default} {
        background-color: var(--colorsUtilityMajor040);
      }
      ${_flatTableHeader.default}, ${_flatTableHead.default} ${_flatTableRowHeader.StyledFlatTableRowHeader},
      ${_flatTableHead.default} ${_flatTableCheckbox.default} {
        background-color: var(--colorsUtilityMajor040);
        border-right: 2px solid var(--colorsUtilityMajor040);
        color: var(--colorsUtilityYin090);
        border-bottom-color: var(--colorsUtilityMajor100);
      }
    `}

  ${({
  hasStickyHead,
  theme
}) => hasStickyHead && (0, _styledComponents.css)`
      ${_flatTableHead.default} {
        position: sticky;
        top: 0;
        left: 0;
        z-index: ${theme.zIndex.overlay + ROW_HEADER_OVERLAY_INCREMENT};
      }
    `}

  ${_flatTableHead.default} ${_flatTableRowHeader.StyledFlatTableRowHeader},
  ${_flatTableHeader.default}.isSticky,
  ${_flatTableHead.default} ${_flatTableCheckbox.default}.isSticky {
    z-index: ${({
  theme
}) => theme.zIndex.overlay + ROW_HEADER_OVERLAY_INCREMENT};
  }

  thead ${_flatTableHeader.default}.isSticky, ${_flatTableCheckbox.default}.isSticky {
    border-right: none;
  }

  ${_flatTableHeader.default}, ${_flatTableCheckbox.default} {
    z-index: ${({
  theme
}) => theme.zIndex.overlay + HEADER_OVERLAY_INCREMENT};
  }

  thead {
    ${_flatTableRow.default}:first-of-type {
      th:first-of-type {
        border-top-left-radius: var(--borderRadius100);
      }
      ${({
  hasVerticalScrollbar
}) => !hasVerticalScrollbar && (0, _styledComponents.css)`
          th:last-of-type {
            border-top-right-radius: var(--borderRadius100);
          }
        `}
    }
  }

  tbody
    ${_flatTableRowHeader.StyledFlatTableRowHeader},
    ${_flatTableCell.StyledFlatTableCell}.isSticky,
    tbody
    ${_flatTableCheckbox.default}.isSticky {
    z-index: ${({
  theme
}) => theme.zIndex.overlay};
  }

  ${({
  footer
}) => footer && (0, _styledComponents.css)`
    tr:last-child:focus {
      :after {
        border-bottom-left-radius: var(--borderRadius000);
        border-bottom-right-radius: var(--borderRadius000);
      }
  `}

  ${({
  footer,
  firstColRowSpanIndex,
  lastColRowSpanIndex,
  hasHorizontalScrollbar,
  hasVerticalScrollbar
}) => !footer && (0, _styledComponents.css)`
      tbody {
        ${firstColRowSpanIndex >= 0 && (0, _styledComponents.css)`
          ${_flatTableRow.default}:nth-of-type(${firstColRowSpanIndex + 1}) {
            th:first-child,
            td:first-child {
              border-bottom-left-radius: var(--borderRadius100);
            }
          }
        `}

        ${lastColRowSpanIndex >= 0 && !hasHorizontalScrollbar && (0, _styledComponents.css)`
          ${_flatTableRow.default}:nth-of-type(${lastColRowSpanIndex + 1}) {
            th:last-child,
            td:last-child {
              border-bottom-right-radius: var(--borderRadius100);
            }
          }
        `}

        ${_flatTableRow.default}:last-of-type {
          ${!hasHorizontalScrollbar && firstColRowSpanIndex === -1 && (0, _styledComponents.css)`
            th:first-child,
            td:first-child {
              border-bottom-left-radius: var(--borderRadius100);
            }
          `}
          ${!hasVerticalScrollbar && !hasHorizontalScrollbar && lastColRowSpanIndex === -1 && (0, _styledComponents.css)`
            th:last-child,
            td:last-child {
              border-bottom-right-radius: var(--borderRadius100);
            }
          `}
        }
      }
    `}
`;
StyledFlatTableWrapper.defaultProps = {
  theme: _themes.baseTheme
};
const StyledFlatTableFooter = exports.StyledFlatTableFooter = _styledComponents.default.div`
  & > ${_pager.StyledPagerContainer} {
    border-top: none;
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }

  ${({
  hasStickyFooter,
  theme
}) => hasStickyFooter && (0, _styledComponents.css)`
      position: sticky;
      bottom: 0px;
      z-index: ${theme.zIndex.overlay + STICKY_FOOTER_OVERLAY_INCREMENT};

      ${_pager.StyledPagerContainer} {
        border-bottom-left-radius: 0;
        border-bottom-right-radius: 0;
      }
    `}
`;
StyledFlatTableFooter.defaultProps = {
  theme: _themes.baseTheme
};