"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableThemeContext = exports.FlatTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _flatTable = require("./flat-table.style");
var _drawer = require("../drawer");
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events/events"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FlatTableThemeContext = exports.FlatTableThemeContext = /*#__PURE__*/_react.default.createContext({
  getTabStopElementId: () => ""
});
const FOCUSABLE_ROW_AND_CELL_QUERY = "tbody tr[tabindex], tbody tr td[tabindex], tbody tr th[tabindex]";
const FlatTable = ({
  caption,
  children,
  hasStickyHead,
  colorTheme = "dark",
  footer,
  hasStickyFooter = false,
  height,
  isZebra,
  size = "medium",
  hasMaxHeight = false,
  ariaDescribedby,
  minHeight,
  overflowX,
  width,
  ...rest
}) => {
  const wrapperRef = (0, _react.useRef)(null);
  const tableRef = (0, _react.useRef)(null);
  const container = (0, _react.useRef)(null);
  const [hasVerticalScrollbar, setHasVerticalScrollbar] = (0, _react.useState)(false);
  const [hasHorizontalScrollbar, setHasHorizontalScrollbar] = (0, _react.useState)(false);
  const [firstColRowSpanIndex, setFirstColRowSpanIndex] = (0, _react.useState)(-1);
  const [lastColRowSpanIndex, setLastColRowSpanIndex] = (0, _react.useState)(-1);
  const [focused, setFocused] = (0, _react.useState)(false);
  const addDefaultHeight = !height && (hasStickyHead || hasStickyFooter);
  const tableStylingProps = {
    caption,
    isZebra,
    size,
    "aria-describedby": ariaDescribedby
  };
  const {
    isInSidebar
  } = (0, _react.useContext)(_drawer.DrawerSidebarContext);
  (0, _react.useLayoutEffect)(() => {
    const findRow = (rows, isFirstCol) => rows.find((row, index) => {
      const cells = Array.from(row.querySelectorAll("td, th"));
      const cell = isFirstCol ? cells.shift() : cells.pop();
      const rowSpan = cell?.getAttribute("rowspan");
      return rowSpan && Number(rowSpan) >= index + 1;
    });

    /* istanbul ignore else */
    if (wrapperRef.current && tableRef.current) {
      const {
        offsetHeight,
        offsetWidth
      } = wrapperRef.current;
      const {
        top,
        bottom,
        right,
        left
      } = tableRef.current?.getBoundingClientRect();
      setHasVerticalScrollbar(bottom - top > offsetHeight);
      setHasHorizontalScrollbar(right - left > offsetWidth);
      const body = tableRef.current.querySelector("tbody");
      const bodyRows = body ? Array.from(body?.querySelectorAll("tr")) : [];
      const {
        length
      } = bodyRows;
      const targetRowFirstCol = findRow(bodyRows.slice(0, length - 1).reverse(), true);
      const targetRowLastCol = findRow(bodyRows.slice(0, length - 1).reverse());
      if (targetRowFirstCol) {
        setFirstColRowSpanIndex(bodyRows.indexOf(targetRowFirstCol));
      }
      if (targetRowLastCol) {
        setLastColRowSpanIndex(bodyRows.indexOf(targetRowLastCol));
      }
    }
  }, [footer, children, height, minHeight]);
  const findParentIndexOfFocusedChild = array => array.findIndex(el => {
    const focusableRowElements = el.querySelectorAll("button, input, a, [tabindex]");

    /* istanbul ignore else */
    if (focusableRowElements) {
      const focusableRowElementsArray = Array.from(focusableRowElements);
      if (focusableRowElementsArray.find(el2 => el2 === document.activeElement)) {
        return true;
      }
    }
    return false;
  });
  const handleKeyDown = ev => {
    const focusableElements = tableRef.current?.querySelectorAll(FOCUSABLE_ROW_AND_CELL_QUERY);
    const focusableElementsArray = Array.from(focusableElements || /* istanbul ignore next */[]);

    /* istanbul ignore if */
    if (!focusableElementsArray.length) {
      return;
    }
    const currentFocusIndex = focusableElementsArray.findIndex(el => el === document.activeElement);
    if (_events.default.isDownKey(ev)) {
      ev.preventDefault();
      if (currentFocusIndex !== -1 && currentFocusIndex < focusableElementsArray.length) {
        focusableElementsArray[currentFocusIndex + 1]?.focus();
      } else {
        // it may be that an element within the row currently has focus
        const index = findParentIndexOfFocusedChild(focusableElementsArray);
        if (index !== -1 && index < focusableElementsArray.length) {
          focusableElementsArray[index + 1]?.focus();
        }
      }
    } else if (_events.default.isUpKey(ev)) {
      ev.preventDefault();
      if (currentFocusIndex > 0) {
        focusableElementsArray[currentFocusIndex - 1]?.focus();
      } else {
        // it may be that an element within the row currently has focus
        const index = findParentIndexOfFocusedChild(focusableElementsArray);
        if (index > 0) {
          focusableElementsArray[index - 1]?.focus();
        }
      }
    }
  };
  const getTabStopElementId = () => {
    const focusableElements = Array.from(tableRef.current?.querySelectorAll(FOCUSABLE_ROW_AND_CELL_QUERY) || /* istanbul ignore next */[]);

    // if no other row is selected/ highlighted, we need to make the first row/ cell a tab stop
    const focusableElement = focusableElements.find(el => el.getAttribute("data-selected") === "true" || el.getAttribute("data-highlighted") === "true") || focusableElements[0];
    const currentlySelectedId = focusableElement?.getAttribute("id") || "";
    return currentlySelectedId;
  };
  return /*#__PURE__*/_react.default.createElement(_flatTable.StyledFlatTableWrapper, _extends({
    ref: wrapperRef,
    "data-component": "flat-table-wrapper",
    isInSidebar: isInSidebar,
    hasStickyHead: hasStickyHead,
    colorTheme: colorTheme,
    minHeight: minHeight,
    overflowY: !isInSidebar && (hasStickyHead || hasStickyFooter) ? "auto" : undefined,
    height: addDefaultHeight && !hasMaxHeight ? "99%" : height,
    maxHeight: hasMaxHeight ? "100%" : undefined,
    display: "flex",
    flexDirection: "column",
    justifyContent: hasStickyFooter || height ? "space-between" : undefined,
    role: "region",
    overflowX: width ? "hidden" : undefined,
    width: width,
    hasStickyFooter: hasStickyFooter,
    hasVerticalScrollbar: hasVerticalScrollbar,
    hasHorizontalScrollbar: hasHorizontalScrollbar,
    footer: !!footer,
    firstColRowSpanIndex: firstColRowSpanIndex,
    lastColRowSpanIndex: lastColRowSpanIndex,
    onKeyDown: handleKeyDown,
    isFocused: focused
  }, rest), /*#__PURE__*/_react.default.createElement(_flatTable.StyledTableContainer, {
    ref: container,
    onFocus: () => {
      if (container.current === document.activeElement) {
        setFocused(true);
      }
    },
    onBlur: () => setFocused(false),
    tabIndex: 0,
    overflowX: overflowX,
    width: width
  }, /*#__PURE__*/_react.default.createElement(_flatTable.StyledFlatTable, _extends({
    ref: tableRef,
    "data-component": "flat-table"
  }, tableStylingProps), caption ? /*#__PURE__*/_react.default.createElement("caption", null, caption) : null, /*#__PURE__*/_react.default.createElement(FlatTableThemeContext.Provider, {
    value: {
      colorTheme,
      size,
      getTabStopElementId
    }
  }, children))), footer && /*#__PURE__*/_react.default.createElement(_flatTable.StyledFlatTableFooter, {
    hasStickyFooter: hasStickyFooter
  }, footer));
};
exports.FlatTable = FlatTable;
FlatTable.displayName = "FlatTable";
var _default = exports.default = FlatTable;