"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _themes = require("../../../style/themes");
var _flatTableCell = require("../flat-table-cell/flat-table-cell.style");
var _flatTableRowHeader = require("../flat-table-row-header/flat-table-row-header.style");
var _flatTableCheckbox = _interopRequireDefault(require("../flat-table-checkbox/flat-table-checkbox.style"));
var _flatTableHeader = _interopRequireDefault(require("../flat-table-header/flat-table-header.style"));
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
var _color = require("../../../style/utils/color");
var _addFocusStyling = _interopRequireDefault(require("../../../style/utils/add-focus-styling"));
var _browserTypeCheck = require("../../../__internal__/utils/helpers/browser-type-check");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const horizontalBorderSizes = {
  medium: "2px",
  large: "4px"
};
const oldFocusStyling = `
  border: 2px solid var(--colorsSemanticFocus500);
`;
const firstColumnOldFocusStyling = `
  outline: 2px solid var(--colorsSemanticFocus500);
  outline-offset: -1px;
`;
const newFocusStyling = `
  ${(0, _addFocusStyling.default)(true)}
  z-index: 1000;
`;
const getLeftStickyStyling = (index, themeOptOut) => index === 0 && /* istanbul ignore next */
themeOptOut && /* istanbul ignore next */
(0, _styledComponents.css)`
    &:first-of-type::before {
      border-left: 3px solid var(--colorsSemanticFocus500);
    }
  `;
const getRightStickyStyling = (index, totalChildren, themeOptOut) => index === totalChildren - 1 && /* istanbul ignore next */
themeOptOut && /* istanbul ignore next */
(0, _styledComponents.css)`
    &:last-of-type {
      border-right: 2px solid var(--colorsSemanticFocus500);
    }
  `;
const stickyColumnFocusStyling = theme => {
  /* istanbul ignore else */
  if (!theme.focusRedesignOptOut) return ``;
  /* istanbul ignore next */
  return `
      width: calc(100% + 1px);
      z-index: ${theme.zIndex.overlay};
      :before {
        content: "";
        border-top: 2px solid var(--colorsSemanticFocus500);
        border-bottom: 2px solid var(--colorsSemanticFocus500);
        display: block;
        left: -2px;
        top: 0px;
        height: calc(100% - 3px);
        width: 103%;
        position: absolute;
        z-index: ${theme.zIndex.overlay};
      }
    }
  `;
};
const borderColor = colorTheme => {
  switch (colorTheme) {
    case "light":
      return "var(--colorsUtilityMajor100)";
    case "transparent-base":
      return "var(--colorsUtilityMajor025)";
    case "transparent-white":
      return "var(--colorsUtilityYang100)";

    // default theme is "dark"
    default:
      return "var(--colorsUtilityMajor400)";
  }
};
const verticalBorderColor = colorTheme => {
  switch (colorTheme) {
    case "transparent-base":
      return "var(--colorsUtilityMajor025)";
    case "transparent-white":
      return "var(--colorsUtilityYang100)";

    // default theme is "dark"
    default:
      return "var(--colorsUtilityMajor100)";
  }
};
const StyledFlatTableRow = _styledComponents.default.tr`
  ${({
  bgColor,
  horizontalBorderColor,
  horizontalBorderSize,
  stickyOffset,
  isRowInteractive,
  isFirstColumnInteractive,
  lhsRowHeaderIndex,
  rhsRowHeaderIndex,
  totalChildren,
  firstCellIndex,
  colorTheme,
  expandable,
  selected,
  highlighted,
  isExpanded,
  isInSidebar,
  isSubRow,
  isFirstSubRow,
  size,
  theme,
  isDragging,
  draggable,
  rowHeight
}) => {
  const backgroundColor = bgColor ? (0, _color.toColor)(theme, bgColor) : undefined;
  const customBorderColor = horizontalBorderColor ? (0, _color.toColor)(theme, horizontalBorderColor) : undefined;
  const colorOfSelected = isInSidebar ? "var(--colorsUtilityMajor150)" : "var(--colorsUtilityMajor075)";
  const colorOfHighlighted = isInSidebar ? "var(--colorsUtilityMajor100)" : "var(--colorsUtilityMajor050)";
  const allCellTypes = `${_flatTableRowHeader.StyledFlatTableRowHeader}, ${_flatTableCell.StyledFlatTableCell}, ${_flatTableCheckbox.default}`;
  return (0, _styledComponents.css)`
      border-collapse: separate;
      border-radius: 0px;
      border-spacing: 0;
      min-width: 100%;
      table-layout: fixed;
      width: auto;

      :focus-visible {
        outline: none;
      }

      ${allCellTypes} {
        ${backgroundColor && `background-color: ${backgroundColor};`}

        ${horizontalBorderSize !== "small" && (0, _styledComponents.css)`
          border-bottom: ${horizontalBorderSizes[horizontalBorderSize]} solid
            var(--colorsUtilityMajor100);
        `}

        ${customBorderColor && (0, _styledComponents.css)`
          border-bottom-color: ${customBorderColor};
        `}
      }

      ${_flatTableRowHeader.StyledFlatTableRowHeader} + td {
        border-left: none;
      }

      ${lhsRowHeaderIndex !== -1 && (0, _styledComponents.css)`
        ${_flatTableRowHeader.StyledFlatTableRowHeader}:nth-child(${lhsRowHeaderIndex + 1}) {
          border-right: 2px solid ${verticalBorderColor(colorTheme)};
        }
      `}

      ${rhsRowHeaderIndex !== -1 && (0, _styledComponents.css)`
        ${_flatTableRowHeader.StyledFlatTableRowHeader}:nth-child(${rhsRowHeaderIndex + 1}) {
          border-left: 2px solid ${verticalBorderColor(colorTheme)};
        }
        ${_flatTableHeader.default}:nth-child(${rhsRowHeaderIndex}) {
          border-right: none;
        }
      `}

      ${rhsRowHeaderIndex === totalChildren - 1 && (0, _styledComponents.css)`
        td:last-of-type {
          border-right: none;
        }
      `}

      ${_flatTableHeader.default} {
        border-bottom: 1px solid ${borderColor(colorTheme)};

        ${!isInSidebar && `
          :first-child {
            border-left: 1px solid ${borderColor(colorTheme)};
          }
        `}
      }

      ${stickyOffset !== undefined && (0, _styledComponents.css)`
        && th {
          top: ${stickyOffset}px;
        }
      `}

      ${isRowInteractive && (0, _styledComponents.css)`
        cursor: pointer;

        :focus {
          position: relative;

          :after {
            content: "";
            box-sizing: border-box;
            position: absolute;
            left: 0px;
            right: 0px;
            top: 0;
            bottom: 0px;
            ${!theme.focusRedesignOptOut ? newFocusStyling : /* istanbul ignore next */oldFocusStyling}
            pointer-events: none;
          }

          :last-child {
            :after {
              border-bottom-left-radius: var(--borderRadius100);
              border-bottom-right-radius: var(--borderRadius100);
            }
          }

          :first-child {
            :after {
              top: 0px;
            }
          }

          /* Styling for safari. Position relative does not work on tr elements on Safari  */
          ${(0, _browserTypeCheck.isSafari)(navigator) && (0, _styledComponents.css)`
            ${theme.focusRedesignOptOut && /* istanbul ignore next */
  (0, _styledComponents.css)`
              outline: 2px solid var(--colorsSemanticFocus500);
              outline-offset: -2px;
              position: static;

              :after {
                content: none;
                border: none;
              }
            `}
            ${!theme.focusRedesignOptOut && (0, _styledComponents.css)`
              position: -webkit-sticky;
              :after {
                border: none;
                content: "";
                height: ${rowHeight}px;
                ${newFocusStyling}
              }
            `}
          `}

          ${theme.focusRedesignOptOut && /* istanbul ignore next */
  (0, _styledComponents.css)`
            td:first-of-type:not(:nth-child(${lhsRowHeaderIndex + 2}))::before {
              border-left: 3px solid var(--colorsSemanticFocus500);
            }

            td:last-of-type:not(:nth-child(${rhsRowHeaderIndex})) {
              border-right: 2px solid var(--colorsSemanticFocus500);
            }
          `}

          ${_flatTableRowHeader.StyledFlatTableRowHeader} {
            ${getLeftStickyStyling(lhsRowHeaderIndex, theme)}
            ${getRightStickyStyling(rhsRowHeaderIndex, totalChildren, theme)}
            ${stickyColumnFocusStyling(theme)}
          }

          ${![-1, 0].includes(lhsRowHeaderIndex) && (0, _styledComponents.css)`
            ${Array.from({
    length: lhsRowHeaderIndex
  }).map((_, index) => {
    return `
                td:nth-of-type(${index + 1}) {
                  ${stickyColumnFocusStyling(theme)}
                }
              `;
  })}
          `}
        }

        :hover {
          ${allCellTypes} {
            background-color: ${backgroundColor || "var(--colorsUtilityMajor025)"};
          }
        }
      `}

      ${isFirstColumnInteractive && (0, _styledComponents.css)`
        td:nth-child(${firstCellIndex + 1}),
        th:nth-child(${firstCellIndex + 1}) {
          cursor: pointer;

          :focus {
            ${!theme.focusRedesignOptOut ? newFocusStyling : /* istanbul ignore next */firstColumnOldFocusStyling}
          }

          :hover {
            background-color: ${backgroundColor || "var(colorsUtilityMajor025)"};
          }
        }
      `}

      ${isInSidebar && (0, _styledComponents.css)`
        ${allCellTypes} {
          background-color: ${bgColor || "var(--colorsUtilityMajor040)"};
          };
        }

        ${_flatTableHeader.default} {
          background-color: var(--colorsUtilityMajor040);
          border-bottom-color: var(--colorsUtilityMajor100);
        }

        td:first-of-type,
        th:first-of-type {
          border-left: none;
        }

        td:last-of-type {
          border-right: none;
        }

        ${_flatTableCheckbox.default} {
          border-right: 1px solid ${colorOfHighlighted};
        }

        ${isRowInteractive && (0, _styledComponents.css)`
            :hover {
              ${_flatTableCell.StyledFlatTableCell},
              ${_flatTableCheckbox.default}:not(th) {
                background-color: ${backgroundColor || "var(--colorsUtilityMajor075)"};
              }
            }
          `}
      `}

      ${expandable && (0, _styledComponents.css)`
        ${_flatTableCell.StyledFlatTableCell}:first-child > div,
        ${_flatTableRowHeader.StyledFlatTableRowHeader}:first-child > div,
        ${_flatTableCheckbox.default} + ${_flatTableCell.StyledFlatTableCell} > div {
          ${_icon.default}[type="chevron_down_thick"]:first-of-type {
            transition: transform 0.3s;
            ${!isExpanded && (0, _styledComponents.css)`
              transform: rotate(-90deg);
            `}
          }
        }
      `}

      ${isSubRow && (0, _styledComponents.css)`
        ${allCellTypes} {
          background-color: ${backgroundColor || "var(--colorsActionMinor025)"};
        }

        ${_flatTableCell.StyledFlatTableCell}:first-child > div,
        ${_flatTableRowHeader.StyledFlatTableRowHeader}:first-child > div,
        ${_flatTableCheckbox.default} + ${_flatTableCell.StyledFlatTableCell} > div {
          padding-left: ${size === "compact" ? "32px" : "40px"};
        }
      `}

      ${isDragging && (0, _styledComponents.css)`
        border: ${isInSidebar ? "var(--colorsUtilityMajor300)" : "var(--colorsUtilityMajor200)"}
          2px solid;
        ${allCellTypes} {
          background-color: ${isInSidebar ? "var(--colorsUtilityMajor200)" : "var(--colorsUtilityMajor150)"};
        }
      `}

      ${draggable && (0, _styledComponents.css)`
        ${_icon.default}:first-of-type {
          font-size: 20px;
          color: var(--colorsActionMinor500);
        }
      `}

      ${isFirstSubRow && (0, _styledComponents.css)`
        ${allCellTypes} {
          box-shadow: var(--boxShadow075);
        }
      `}

      ${highlighted && (0, _styledComponents.css)`
        ${allCellTypes} {
          background-color: ${backgroundColor || colorOfHighlighted};
        }

        :hover {
          ${_flatTableCell.StyledFlatTableCell},
          ${_flatTableRowHeader.StyledFlatTableRowHeader},
          ${_flatTableCheckbox.default}:not(th) {
            background-color: ${backgroundColor || colorOfHighlighted};
          }
        }
      `}

      ${selected && (0, _styledComponents.css)`
        ${_flatTableCell.StyledFlatTableCell},
        ${_flatTableCheckbox.default} {
          background-color: ${backgroundColor || colorOfSelected};
        }

        :hover {
          ${_flatTableCell.StyledFlatTableCell},
          ${_flatTableRowHeader.StyledFlatTableRowHeader},
          ${_flatTableCheckbox.default}:not(th) {
            background-color: ${backgroundColor || colorOfSelected};
          }
        }
      `}
    `;
}}
`;
StyledFlatTableRow.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledFlatTableRow;