"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _flatTableRow = _interopRequireDefault(require("./flat-table-row.style"));
var _drawer = require("../../drawer");
var _flatTableRowHeader = _interopRequireDefault(require("../flat-table-row-header"));
var _flatTableRowDraggable = _interopRequireDefault(require("./__internal__/flat-table-row-draggable.component"));
var _flatTable = require("../flat-table.component");
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _flatTableRowContext = _interopRequireDefault(require("./__internal__/flat-table-row-context"));
var _subRowProvider = _interopRequireWildcard(require("./__internal__/sub-row-provider"));
var _internal__ = require("../__internal__");
var _flatTableHead = require("../flat-table-head/flat-table-head.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FlatTableRow = exports.FlatTableRow = /*#__PURE__*/_react.default.forwardRef(({
  children,
  onClick,
  expandable,
  expandableArea = "wholeRow",
  expanded = false,
  highlighted,
  selected,
  subRows,
  bgColor,
  horizontalBorderColor,
  horizontalBorderSize = "small",
  id,
  draggable,
  findItem,
  moveItem,
  ...rest
}, ref) => {
  const internalId = (0, _react.useRef)(id ? String(id) : (0, _guid.default)());
  const [isExpanded, setIsExpanded] = (0, _react.useState)(expanded);
  let rowRef = (0, _react.useRef)(null);
  if (ref) {
    rowRef = ref;
  }
  const firstColumnExpandable = expandableArea === "firstColumn";
  const [leftPositions, setLeftPositions] = (0, _react.useState)({});
  const [rightPositions, setRightPositions] = (0, _react.useState)({});
  const [firstCellIndex, setFirstCellIndex] = (0, _react.useState)(0);
  const [lhsRowHeaderIndex, setLhsRowHeaderIndex] = (0, _react.useState)(-1);
  const [rhsRowHeaderIndex, setRhsRowHeaderIndex] = (0, _react.useState)(-1);
  const [firstCellId, setFirstCellId] = (0, _react.useState)(null);
  const [cellsArray, setCellsArray] = (0, _react.useState)([]);
  const [tabIndex, setTabIndex] = (0, _react.useState)(-1);
  let interactiveRowProps = {};
  (0, _react.useLayoutEffect)(() => {
    const checkForPositionUpdates = (updated, current) => {
      const updatedKeys = Object.keys(updated);
      const currentKeys = Object.keys(current);
      if (updatedKeys.length !== currentKeys.length) {
        return true;
      }
      return updatedKeys.some(key => updated[key] !== current[key]);
    };
    const cells = rowRef.current?.querySelectorAll("th, td");
    const cellArray = Array.from(cells || []);
    setCellsArray(cellArray);
    const firstIndex = cellArray.findIndex(cell => cell.getAttribute("data-component") !== "flat-table-checkbox");
    const lhsIndex = cellArray.findIndex(cell => cell.getAttribute("data-sticky-align") === "left");
    const rhsIndex = cellArray.findIndex(cell => cell.getAttribute("data-sticky-align") === "right");
    setLhsRowHeaderIndex(lhsIndex);
    setRhsRowHeaderIndex(rhsIndex);
    if (firstIndex !== -1) {
      setFirstCellIndex(firstIndex);
      setFirstCellId(cellArray[firstIndex].getAttribute("id"));
    } else {
      setFirstCellIndex(0);
    }
    if (lhsIndex !== -1) {
      const updatedLeftPositions = (0, _internal__.buildPositionMap)(cellArray.slice(0, lhsRowHeaderIndex + 1), "offsetWidth");
      if (checkForPositionUpdates(updatedLeftPositions, leftPositions)) {
        setLeftPositions(updatedLeftPositions);
      }
    }
    if (rhsIndex !== -1) {
      const updatedRightPositions = (0, _internal__.buildPositionMap)(cellArray.slice(rhsRowHeaderIndex, cellArray.length).reverse(), "offsetWidth");
      if (checkForPositionUpdates(updatedRightPositions, rightPositions)) {
        setRightPositions(updatedRightPositions);
      }
    }
  }, [children, leftPositions, lhsRowHeaderIndex, rhsRowHeaderIndex, rightPositions]);
  const noStickyColumnsOverlap = (0, _react.useMemo)(() => {
    const hasLhsColumn = lhsRowHeaderIndex !== -1;
    const hasRhsColumn = rhsRowHeaderIndex !== -1;
    if (!hasLhsColumn || !hasRhsColumn) return true;
    return lhsRowHeaderIndex < rhsRowHeaderIndex;
  }, [lhsRowHeaderIndex, rhsRowHeaderIndex]);
  !noStickyColumnsOverlap ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `Do not render a right hand side \`${_flatTableRowHeader.default.displayName}\` before left hand side \`${_flatTableRowHeader.default.displayName}\``) : (0, _invariant.default)(false) : void 0;
  const {
    colorTheme,
    size,
    getTabStopElementId
  } = (0, _react.useContext)(_flatTable.FlatTableThemeContext);
  const {
    isInSidebar
  } = (0, _react.useContext)(_drawer.DrawerSidebarContext);
  const {
    stickyOffsets
  } = (0, _react.useContext)(_flatTableHead.FlatTableHeadContext);
  const toggleExpanded = () => setIsExpanded(!isExpanded);
  function onKeyDown(ev) {
    const isEnterOrSpaceKey = _events.default.isEnterKey(ev) || _events.default.isSpaceKey(ev);
    if (expandable && !firstColumnExpandable && document.activeElement === rowRef.current && isEnterOrSpaceKey) {
      ev.preventDefault();
      toggleExpanded();
    }
    if (isEnterOrSpaceKey && onClick) {
      onClick(ev);
    }
  }
  function handleClick(ev) {
    if (onClick) {
      onClick(ev);
    }
    if (expandable && !firstColumnExpandable) {
      toggleExpanded();
    }
  }
  if (onClick || expandable) {
    interactiveRowProps = {
      isRowInteractive: !firstColumnExpandable,
      tabIndex: firstColumnExpandable ? undefined : tabIndex,
      onKeyDown,
      isFirstColumnInteractive: firstColumnExpandable,
      isExpanded
    };
  }
  function handleCellKeyDown(ev) {
    const isEnterOrSpaceKey = _events.default.isEnterKey(ev) || _events.default.isSpaceKey(ev);
    if (isEnterOrSpaceKey) {
      ev.preventDefault();
      toggleExpanded();
    }
  }
  (0, _react.useEffect)(() => {
    setIsExpanded(expanded);
  }, [expanded]);
  (0, _react.useEffect)(() => {
    setTabIndex(getTabStopElementId() === internalId.current ? 0 : -1);
  }, [getTabStopElementId]);
  const {
    isSubRow,
    firstRowId,
    addRow,
    removeRow
  } = (0, _react.useContext)(_subRowProvider.SubRowContext);
  (0, _react.useEffect)(() => {
    const rowId = internalId.current;
    addRow(rowId);
    return () => {
      removeRow(rowId);
    };
  }, [addRow, removeRow]);
  const isFirstSubRow = firstRowId === internalId.current;
  const rowComponent = () => /*#__PURE__*/_react.default.createElement(_flatTableRow.default, _extends({
    isInSidebar: isInSidebar,
    expandable: expandable,
    isSubRow: isSubRow,
    isFirstSubRow: isFirstSubRow,
    "data-element": isSubRow ? "flat-table-sub-row" : "flat-table-row",
    highlighted: highlighted,
    selected: selected,
    onClick: handleClick,
    firstCellIndex: firstCellIndex,
    ref: rowRef,
    lhsRowHeaderIndex: lhsRowHeaderIndex,
    rhsRowHeaderIndex: rhsRowHeaderIndex,
    colorTheme: colorTheme,
    size: size,
    stickyOffset: stickyOffsets[internalId.current],
    bgColor: bgColor,
    horizontalBorderColor: horizontalBorderColor,
    horizontalBorderSize: horizontalBorderSize,
    draggable: draggable,
    totalChildren: cellsArray.length,
    id: internalId.current,
    "data-selected": selected && expandableArea === "wholeRow",
    "data-highlighted": highlighted && expandableArea === "wholeRow",
    rowHeight: rowRef?.current?.offsetHeight
  }, interactiveRowProps, rest), /*#__PURE__*/_react.default.createElement(_flatTableRowContext.default.Provider, {
    value: {
      firstCellId,
      expandable,
      leftPositions,
      rightPositions,
      firstColumnExpandable,
      onKeyDown: handleCellKeyDown,
      onClick: () => toggleExpanded(),
      highlighted,
      selected
    }
  }, children));
  const draggableComponent = () => /*#__PURE__*/_react.default.createElement(_flatTableRowDraggable.default, {
    id: internalId.current,
    moveItem: moveItem,
    findItem: findItem,
    rowRef: rowRef
  }, rowComponent());
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, draggable ? draggableComponent() : rowComponent(), isExpanded && subRows && /*#__PURE__*/_react.default.createElement(_subRowProvider.default, null, subRows));
});
if (process.env.NODE_ENV !== "production") {
  FlatTableRow.propTypes = {
    "bgColor": _propTypes.default.string,
    "children": _propTypes.default.node,
    "draggable": _propTypes.default.bool,
    "expandable": _propTypes.default.bool,
    "expandableArea": _propTypes.default.oneOf(["firstColumn", "wholeRow"]),
    "expanded": _propTypes.default.bool,
    "findItem": _propTypes.default.func,
    "highlighted": _propTypes.default.bool,
    "horizontalBorderColor": _propTypes.default.string,
    "horizontalBorderSize": _propTypes.default.oneOf(["large", "medium", "small"]),
    "id": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "moveItem": _propTypes.default.func,
    "onClick": _propTypes.default.func,
    "selected": _propTypes.default.bool,
    "subRows": _propTypes.default.node
  };
}
FlatTableRow.displayName = "FlatTableRow";
var _default = exports.default = FlatTableRow;