import React from "react";
import { TableBorderSize } from "..";
import { FlatTableRowDraggableProps } from "./__internal__/flat-table-row-draggable.component";
export interface FlatTableRowProps {
    /** Overrides default cell color, provide design token, any color from palette or any valid css color value. */
    bgColor?: string;
    /** Array of FlatTableHeader or FlatTableCell. FlatTableRowHeader could also be passed. */
    children: React.ReactNode;
    /** Allows the row to be expanded, must be used with the `subRows` prop. */
    expandable?: boolean;
    /** Sets an expandable row to be expanded on start */
    expanded?: boolean;
    /** Area to click to open sub rows when expandable. Default is `wholeRow` */
    expandableArea?: "wholeRow" | "firstColumn";
    /** Allows developers to manually control highlighted state for the row. */
    highlighted?: boolean;
    /** Sets the color of the bottom border in the row */
    horizontalBorderColor?: string;
    /** Sets the weight of the bottom border in the row */
    horizontalBorderSize?: TableBorderSize;
    /** Function to handle click event. If provided the Component could be focused with tab key. */
    onClick?: (ev: React.MouseEvent<HTMLElement>) => void;
    /** Allows developers to manually control selected state for the row. */
    selected?: boolean;
    /** Sub rows to be shown when the row is expanded, must be used with the `expandable` prop. */
    subRows?: React.ReactNode;
    id?: string | number;
    /**
     * @private
     * @ignore
     */
    findItem?: FlatTableRowDraggableProps["findItem"];
    /**
     * @private
     * @ignore
     */
    moveItem?: FlatTableRowDraggableProps["moveItem"];
    /** @ignore @private position in header if multiple rows */
    draggable?: boolean;
}
export declare const FlatTableRow: React.ForwardRefExoticComponent<FlatTableRowProps & React.RefAttributes<HTMLTableRowElement>>;
export default FlatTableRow;
